/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import shadow.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shadow.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import shadow.org.bouncycastle.asn1.x9.X9ECParameters;
import shadow.org.bouncycastle.crypto.ec.CustomNamedCurves;
import shadow.org.bouncycastle.math.ec.ECCurve;
import shadow.org.bouncycastle.math.ec.ECPoint;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPUtil;
import shadow.org.bouncycastle.util.BigIntegers;

class JcaJcePGPUtil {
    JcaJcePGPUtil() {
    }

    public static SecretKey makeSymmetricKey(int n, byte[] byArray) throws PGPException {
        String string = PGPUtil.getSymmetricCipherName(n);
        if (string == null) {
            throw new PGPException("unknown symmetric algorithm: " + n);
        }
        return new SecretKeySpec(byArray, string);
    }

    static ECPoint decodePoint(BigInteger bigInteger, ECCurve eCCurve) throws IOException {
        return eCCurve.decodePoint(BigIntegers.asUnsignedByteArray(bigInteger));
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            return ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }
}

