/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import shadow.org.bouncycastle.crypto.BufferedBlockCipher;
import shadow.org.bouncycastle.crypto.InvalidCipherTextException;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcUtil;

public class BcPBESecretKeyDecryptorBuilder {
    private PGPDigestCalculatorProvider calculatorProvider;

    public BcPBESecretKeyDecryptorBuilder(PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.calculatorProvider = pGPDigestCalculatorProvider;
    }

    public PBESecretKeyDecryptor build(char[] cArray) {
        return new PBESecretKeyDecryptor(cArray, this.calculatorProvider){

            public byte[] recoverKeyData(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) throws PGPException {
                try {
                    BufferedBlockCipher bufferedBlockCipher = BcUtil.createSymmetricKeyWrapper(false, BcImplProvider.createBlockCipher(n), byArray, byArray2);
                    byte[] byArray4 = new byte[n3];
                    int n4 = bufferedBlockCipher.processBytes(byArray3, n2, n3, byArray4, 0);
                    n4 += bufferedBlockCipher.doFinal(byArray4, n4);
                    return byArray4;
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new PGPException("decryption failed: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
                }
            }
        };
    }
}

