/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import shadow.org.bouncycastle.bcpg.ArmoredOutputStream;
import shadow.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shadow.org.bouncycastle.openpgp.PGPCompressedData;
import shadow.org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import shadow.org.bouncycastle.openpgp.PGPEncryptedDataList;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPLiteralData;
import shadow.org.bouncycastle.openpgp.PGPPBEEncryptedData;
import shadow.org.bouncycastle.openpgp.PGPUtil;
import shadow.org.bouncycastle.openpgp.examples.PGPExampleUtil;
import shadow.org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import shadow.org.bouncycastle.util.io.Streams;

public class PBEFileProcessor {
    private static void decryptFile(String string, char[] cArray) throws IOException, NoSuchProviderException, PGPException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        PBEFileProcessor.decryptFile(bufferedInputStream, cArray);
        ((InputStream)bufferedInputStream).close();
    }

    private static void decryptFile(InputStream inputStream, char[] cArray) throws IOException, NoSuchProviderException, PGPException {
        Object object;
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream = PGPUtil.getDecoderStream(inputStream));
        Object object2 = jcaPGPObjectFactory.nextObject();
        PGPEncryptedDataList pGPEncryptedDataList = object2 instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)object2 : (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream2 = pGPPBEEncryptedData.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(cArray));
        JcaPGPObjectFactory jcaPGPObjectFactory2 = new JcaPGPObjectFactory(inputStream2);
        object2 = jcaPGPObjectFactory2.nextObject();
        if (object2 instanceof PGPCompressedData) {
            object = (PGPCompressedData)object2;
            jcaPGPObjectFactory2 = new JcaPGPObjectFactory(((PGPCompressedData)object).getDataStream());
            object2 = jcaPGPObjectFactory2.nextObject();
        }
        object = (PGPLiteralData)object2;
        InputStream inputStream3 = ((PGPLiteralData)object).getInputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(((PGPLiteralData)object).getFileName()));
        Streams.pipeAll(inputStream3, bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
        if (pGPPBEEncryptedData.isIntegrityProtected()) {
            if (!pGPPBEEncryptedData.verify()) {
                System.err.println("message failed integrity check");
            } else {
                System.err.println("message integrity check passed");
            }
        } else {
            System.err.println("no message integrity check");
        }
    }

    private static void encryptFile(String string, String string2, char[] cArray, boolean bl, boolean bl2) throws IOException, NoSuchProviderException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        PBEFileProcessor.encryptFile(bufferedOutputStream, string2, cArray, bl, bl2);
        ((OutputStream)bufferedOutputStream).close();
    }

    private static void encryptFile(OutputStream outputStream, String string, char[] cArray, boolean bl, boolean bl2) throws IOException, NoSuchProviderException {
        block4: {
            if (bl) {
                outputStream = new ArmoredOutputStream(outputStream);
            }
            try {
                byte[] byArray = PGPExampleUtil.compressFile(string, 1);
                PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setWithIntegrityPacket(bl2).setSecureRandom(new SecureRandom()).setProvider("BC"));
                pGPEncryptedDataGenerator.addMethod(new JcePBEKeyEncryptionMethodGenerator(cArray).setProvider("BC"));
                OutputStream outputStream2 = pGPEncryptedDataGenerator.open(outputStream, byArray.length);
                outputStream2.write(byArray);
                outputStream2.close();
                if (bl) {
                    outputStream.close();
                }
            }
            catch (PGPException pGPException) {
                System.err.println(pGPException);
                if (pGPException.getUnderlyingException() == null) break block4;
                pGPException.getUnderlyingException().printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (stringArray[0].equals("-e")) {
            if (stringArray[1].equals("-a") || stringArray[1].equals("-ai") || stringArray[1].equals("-ia")) {
                PBEFileProcessor.encryptFile(stringArray[2] + ".asc", stringArray[2], stringArray[3].toCharArray(), true, stringArray[1].indexOf(105) > 0);
            } else if (stringArray[1].equals("-i")) {
                PBEFileProcessor.encryptFile(stringArray[2] + ".bpg", stringArray[2], stringArray[3].toCharArray(), false, true);
            } else {
                PBEFileProcessor.encryptFile(stringArray[1] + ".bpg", stringArray[1], stringArray[2].toCharArray(), false, false);
            }
        } else if (stringArray[0].equals("-d")) {
            PBEFileProcessor.decryptFile(stringArray[1], stringArray[2].toCharArray());
        } else {
            System.err.println("usage: PBEFileProcessor -e [-ai]|-d file passPhrase");
        }
    }
}

