/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.gpg.keybox;

import java.io.IOException;
import shadow.org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import shadow.org.bouncycastle.util.Arrays;

public class KeyInformation {
    private final byte[] fingerprint;
    private final long offsetToKeyID;
    private final int keyFlags;
    private final byte[] filler;
    private final byte[] keyID;

    KeyInformation(byte[] byArray, long l, int n, byte[] byArray2, byte[] byArray3) {
        this.fingerprint = Arrays.clone(byArray);
        this.offsetToKeyID = l;
        this.keyFlags = n;
        this.filler = Arrays.clone(byArray2);
        this.keyID = Arrays.clone(byArray3);
    }

    static KeyInformation getInstance(Object object, int n, int n2) throws IOException {
        if (object instanceof KeyInformation) {
            return (KeyInformation)object;
        }
        KeyBoxByteBuffer keyBoxByteBuffer = KeyBoxByteBuffer.wrap(object);
        int n3 = keyBoxByteBuffer.position();
        byte[] byArray = keyBoxByteBuffer.bN(20);
        long l = keyBoxByteBuffer.u32();
        byte[] byArray2 = null;
        if (l > 0L) {
            byArray2 = keyBoxByteBuffer.rangeOf((int)((long)n2 + l), (int)((long)n2 + l + 8L));
        }
        int n4 = keyBoxByteBuffer.u16();
        keyBoxByteBuffer.u16();
        byte[] byArray3 = keyBoxByteBuffer.bN(n - (keyBoxByteBuffer.position() - n3));
        return new KeyInformation(byArray, l, n4, byArray3, byArray2);
    }

    public byte[] getFingerprint() {
        return Arrays.clone(this.fingerprint);
    }

    public int getKeyFlags() {
        return this.keyFlags;
    }

    public byte[] getFiller() {
        return Arrays.clone(this.filler);
    }

    public byte[] getKeyID() {
        return Arrays.clone(this.keyID);
    }
}

