/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.cms;

import shadow.org.bouncycastle.asn1.ASN1OctetString;
import shadow.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import shadow.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import shadow.org.bouncycastle.asn1.cms.RecipientIdentifier;
import shadow.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shadow.org.bouncycastle.cms.AuthAttributesProvider;
import shadow.org.bouncycastle.cms.CMSException;
import shadow.org.bouncycastle.cms.CMSSecureReadable;
import shadow.org.bouncycastle.cms.KeyTransRecipient;
import shadow.org.bouncycastle.cms.KeyTransRecipientId;
import shadow.org.bouncycastle.cms.Recipient;
import shadow.org.bouncycastle.cms.RecipientInformation;
import shadow.org.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

