/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.sun.jna.platform.win32.COM;

import shadow.com.sun.jna.WString;
import shadow.com.sun.jna.platform.win32.COM.COMUtils;
import shadow.com.sun.jna.platform.win32.COM.ITypeInfo;
import shadow.com.sun.jna.platform.win32.COM.ITypeLib;
import shadow.com.sun.jna.platform.win32.COM.TypeComp;
import shadow.com.sun.jna.platform.win32.COM.TypeInfo;
import shadow.com.sun.jna.platform.win32.COM.TypeInfoUtil;
import shadow.com.sun.jna.platform.win32.COM.TypeLib;
import shadow.com.sun.jna.platform.win32.Guid;
import shadow.com.sun.jna.platform.win32.Kernel32;
import shadow.com.sun.jna.platform.win32.OaIdl;
import shadow.com.sun.jna.platform.win32.Ole32;
import shadow.com.sun.jna.platform.win32.OleAuto;
import shadow.com.sun.jna.platform.win32.WTypes;
import shadow.com.sun.jna.platform.win32.WinDef;
import shadow.com.sun.jna.platform.win32.WinNT;
import shadow.com.sun.jna.ptr.PointerByReference;

public class TypeLibUtil {
    public static final OleAuto OLEAUTO = OleAuto.INSTANCE;
    private ITypeLib typelib;
    private WinDef.LCID lcid = Kernel32.INSTANCE.GetUserDefaultLCID();
    private String name;
    private String docString;
    private int helpContext;
    private String helpFile;

    public TypeLibUtil(String clsidStr, int wVerMajor, int wVerMinor) {
        Guid.CLSID.ByReference clsid = new Guid.CLSID.ByReference();
        WinNT.HRESULT hr = Ole32.INSTANCE.CLSIDFromString(new WString(clsidStr), clsid);
        COMUtils.checkRC(hr);
        PointerByReference pTypeLib = new PointerByReference();
        hr = OleAuto.INSTANCE.LoadRegTypeLib(clsid, wVerMajor, wVerMinor, this.lcid, pTypeLib);
        COMUtils.checkRC(hr);
        this.typelib = new TypeLib(pTypeLib.getValue());
        this.initTypeLibInfo();
    }

    public TypeLibUtil(String file) {
        PointerByReference pTypeLib = new PointerByReference();
        WinNT.HRESULT hr = OleAuto.INSTANCE.LoadTypeLib(new WString(file), pTypeLib);
        COMUtils.checkRC(hr);
        this.typelib = new TypeLib(pTypeLib.getValue());
        this.initTypeLibInfo();
    }

    private void initTypeLibInfo() {
        TypeLibDoc documentation = this.getDocumentation(-1);
        this.name = documentation.getName();
        this.docString = documentation.getDocString();
        this.helpContext = documentation.getHelpContext();
        this.helpFile = documentation.getHelpFile();
    }

    public int getTypeInfoCount() {
        return this.typelib.GetTypeInfoCount().intValue();
    }

    public OaIdl.TYPEKIND getTypeInfoType(int index) {
        OaIdl.TYPEKIND.ByReference typekind = new OaIdl.TYPEKIND.ByReference();
        WinNT.HRESULT hr = this.typelib.GetTypeInfoType(new WinDef.UINT((long)index), typekind);
        COMUtils.checkRC(hr);
        return typekind;
    }

    public ITypeInfo getTypeInfo(int index) {
        PointerByReference ppTInfo = new PointerByReference();
        WinNT.HRESULT hr = this.typelib.GetTypeInfo(new WinDef.UINT((long)index), ppTInfo);
        COMUtils.checkRC(hr);
        return new TypeInfo(ppTInfo.getValue());
    }

    public TypeInfoUtil getTypeInfoUtil(int index) {
        return new TypeInfoUtil(this.getTypeInfo(index));
    }

    public OaIdl.TLIBATTR getLibAttr() {
        PointerByReference ppTLibAttr = new PointerByReference();
        WinNT.HRESULT hr = this.typelib.GetLibAttr(ppTLibAttr);
        COMUtils.checkRC(hr);
        return new OaIdl.TLIBATTR(ppTLibAttr.getValue());
    }

    public TypeComp GetTypeComp() {
        PointerByReference ppTComp = new PointerByReference();
        WinNT.HRESULT hr = this.typelib.GetTypeComp(ppTComp);
        COMUtils.checkRC(hr);
        return new TypeComp(ppTComp.getValue());
    }

    public TypeLibDoc getDocumentation(int index) {
        WTypes.BSTRByReference pBstrName = new WTypes.BSTRByReference();
        WTypes.BSTRByReference pBstrDocString = new WTypes.BSTRByReference();
        WinDef.DWORDByReference pdwHelpContext = new WinDef.DWORDByReference();
        WTypes.BSTRByReference pBstrHelpFile = new WTypes.BSTRByReference();
        WinNT.HRESULT hr = this.typelib.GetDocumentation(index, pBstrName, pBstrDocString, pdwHelpContext, pBstrHelpFile);
        COMUtils.checkRC(hr);
        TypeLibDoc typeLibDoc = new TypeLibDoc(pBstrName.getString(), pBstrDocString.getString(), pdwHelpContext.getValue().intValue(), pBstrHelpFile.getString());
        OLEAUTO.SysFreeString(pBstrName.getValue());
        OLEAUTO.SysFreeString(pBstrDocString.getValue());
        OLEAUTO.SysFreeString(pBstrHelpFile.getValue());
        return typeLibDoc;
    }

    public IsName IsName(String nameBuf, int hashVal) {
        WTypes.LPOLESTR szNameBuf = new WTypes.LPOLESTR(nameBuf);
        WinDef.ULONG lHashVal = new WinDef.ULONG(hashVal);
        WinDef.BOOLByReference pfName = new WinDef.BOOLByReference();
        WinNT.HRESULT hr = this.typelib.IsName(szNameBuf, lHashVal, pfName);
        COMUtils.checkRC(hr);
        return new IsName(szNameBuf.getValue(), pfName.getValue().booleanValue());
    }

    public FindName FindName(String name, int hashVal, short found) {
        WTypes.BSTRByReference szNameBuf = new WTypes.BSTRByReference(OleAuto.INSTANCE.SysAllocString(name));
        WinDef.ULONG lHashVal = new WinDef.ULONG(hashVal);
        WinDef.USHORTByReference pcFound = new WinDef.USHORTByReference(found);
        WinNT.HRESULT hr = this.typelib.FindName(szNameBuf, lHashVal, null, null, pcFound);
        COMUtils.checkRC(hr);
        found = pcFound.getValue().shortValue();
        ITypeInfo[] ppTInfo = new ITypeInfo[found];
        OaIdl.MEMBERID[] rgMemId = new OaIdl.MEMBERID[found];
        hr = this.typelib.FindName(szNameBuf, lHashVal, ppTInfo, rgMemId, pcFound);
        COMUtils.checkRC(hr);
        FindName findName = new FindName(szNameBuf.getString(), ppTInfo, rgMemId, found);
        OLEAUTO.SysFreeString(szNameBuf.getValue());
        return findName;
    }

    public void ReleaseTLibAttr(OaIdl.TLIBATTR pTLibAttr) {
        this.typelib.ReleaseTLibAttr(pTLibAttr);
    }

    public WinDef.LCID getLcid() {
        return this.lcid;
    }

    public ITypeLib getTypelib() {
        return this.typelib;
    }

    public String getName() {
        return this.name;
    }

    public String getDocString() {
        return this.docString;
    }

    public long getHelpContext() {
        return this.helpContext;
    }

    public String getHelpFile() {
        return this.helpFile;
    }

    public static class FindName {
        private String nameBuf;
        private ITypeInfo[] pTInfo;
        private OaIdl.MEMBERID[] rgMemId;
        private short pcFound;

        public FindName(String nameBuf, ITypeInfo[] pTInfo, OaIdl.MEMBERID[] rgMemId, short pcFound) {
            this.nameBuf = nameBuf;
            this.pTInfo = pTInfo;
            this.rgMemId = rgMemId;
            this.pcFound = pcFound;
        }

        public String getNameBuf() {
            return this.nameBuf;
        }

        public ITypeInfo[] getTInfo() {
            return this.pTInfo;
        }

        public OaIdl.MEMBERID[] getMemId() {
            return this.rgMemId;
        }

        public short getFound() {
            return this.pcFound;
        }
    }

    public static class IsName {
        private String nameBuf;
        private boolean name;

        public IsName(String nameBuf, boolean name) {
            this.nameBuf = nameBuf;
            this.name = name;
        }

        public String getNameBuf() {
            return this.nameBuf;
        }

        public boolean isName() {
            return this.name;
        }
    }

    public static class TypeLibDoc {
        private String name;
        private String docString;
        private int helpContext;
        private String helpFile;

        public TypeLibDoc(String name, String docString, int helpContext, String helpFile) {
            this.name = name;
            this.docString = docString;
            this.helpContext = helpContext;
            this.helpFile = helpFile;
        }

        public String getName() {
            return this.name;
        }

        public String getDocString() {
            return this.docString;
        }

        public int getHelpContext() {
            return this.helpContext;
        }

        public String getHelpFile() {
            return this.helpFile;
        }
    }
}

