/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.googlecode.javaewah32;

import shadow.com.googlecode.javaewah.IntIterator;
import shadow.com.googlecode.javaewah32.Buffer32;
import shadow.com.googlecode.javaewah32.EWAHIterator32;
import shadow.com.googlecode.javaewah32.RunningLengthWord32;

final class ClearIntIterator32
implements IntIterator {
    private final EWAHIterator32 ewahIter;
    private final int sizeInBits;
    private final Buffer32 buffer;
    private int position;
    private int runningLength;
    private int word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    ClearIntIterator32(EWAHIterator32 ewahIter, int sizeInBits) {
        this.ewahIter = ewahIter;
        this.sizeInBits = sizeInBits;
        this.buffer = ewahIter.buffer();
        this.hasNext = this.moveToNext();
    }

    public boolean moveToNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (!this.ewahIter.hasNext()) {
                return false;
            }
            this.setRunningLengthWord(this.ewahIter.next());
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int next() {
        int answer;
        if (this.runningHasNext()) {
            answer = this.position++;
        } else {
            int t = this.word & -this.word;
            answer = this.literalPosition + Integer.bitCount(t - 1);
            this.word ^= t;
        }
        this.hasNext = this.moveToNext();
        return answer;
    }

    private void setRunningLengthWord(RunningLengthWord32 rlw) {
        this.runningLength = Math.min(this.sizeInBits, 32 * rlw.getRunningLength() + this.position);
        if (rlw.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = this.ewahIter.literalWords();
        this.wordLength = this.wordPosition + rlw.getNumberOfLiteralWords();
    }

    private boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private boolean literalHasNext() {
        while (this.word == 0 && this.wordPosition < this.wordLength) {
            int usedBitsInLast;
            this.word = ~this.buffer.getWord(this.wordPosition++);
            if (this.wordPosition == this.wordLength && !this.ewahIter.hasNext() && (usedBitsInLast = this.sizeInBits % 32) > 0) {
                this.word &= -1 >>> 32 - usedBitsInLast;
            }
            this.literalPosition = this.position;
            this.position += 32;
        }
        return this.word != 0;
    }
}

