/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.transport;

import java.security.AccessController;
import java.util.Iterator;
import java.util.ServiceLoader;
import shadow.org.eclipse.jgit.errors.TransportException;
import shadow.org.eclipse.jgit.transport.CredentialsProvider;
import shadow.org.eclipse.jgit.transport.RemoteSession;
import shadow.org.eclipse.jgit.transport.URIish;
import shadow.org.eclipse.jgit.util.FS;
import shadow.org.eclipse.jgit.util.SystemReader;

public abstract class SshSessionFactory {
    private static SshSessionFactory INSTANCE = SshSessionFactory.loadSshSessionFactory();

    private static SshSessionFactory loadSshSessionFactory() {
        ServiceLoader<SshSessionFactory> loader = ServiceLoader.load(SshSessionFactory.class);
        Iterator<SshSessionFactory> iter = loader.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public static SshSessionFactory getInstance() {
        return INSTANCE;
    }

    public static void setInstance(SshSessionFactory newFactory) {
        INSTANCE = newFactory != null ? newFactory : SshSessionFactory.loadSshSessionFactory();
    }

    public static String getLocalUserName() {
        return AccessController.doPrivileged(() -> SystemReader.getInstance().getProperty("user.name"));
    }

    public abstract RemoteSession getSession(URIish var1, CredentialsProvider var2, FS var3, int var4) throws TransportException;

    public abstract String getType();

    public void releaseSession(RemoteSession session) {
        session.disconnect();
    }
}

