/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.internal.fsck;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import shadow.org.eclipse.jgit.errors.CorruptObjectException;
import shadow.org.eclipse.jgit.errors.CorruptPackIndexException;
import shadow.org.eclipse.jgit.errors.MissingObjectException;
import shadow.org.eclipse.jgit.internal.JGitText;
import shadow.org.eclipse.jgit.internal.fsck.FsckError;
import shadow.org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import shadow.org.eclipse.jgit.internal.storage.file.PackIndex;
import shadow.org.eclipse.jgit.lib.AnyObjectId;
import shadow.org.eclipse.jgit.lib.ObjectDatabase;
import shadow.org.eclipse.jgit.lib.ObjectIdOwnerMap;
import shadow.org.eclipse.jgit.transport.PackParser;
import shadow.org.eclipse.jgit.transport.PackedObjectInfo;

public class FsckPackParser
extends PackParser {
    private final CRC32 crc;
    private final ReadableChannel channel;
    private final Set<FsckError.CorruptObject> corruptObjects = new HashSet<FsckError.CorruptObject>();
    private long expectedObjectCount = -1L;
    private long offset;
    private int blockSize;

    public FsckPackParser(ObjectDatabase db, ReadableChannel channel) {
        super(db, Channels.newInputStream(channel));
        this.channel = channel;
        this.setCheckObjectCollisions(false);
        this.crc = new CRC32();
        this.blockSize = channel.blockSize() > 0 ? channel.blockSize() : 65536;
    }

    @Override
    protected void onPackHeader(long objCnt) throws IOException {
        if (this.expectedObjectCount >= 0L) {
            this.setExpectedObjectCount(this.expectedObjectCount);
        }
    }

    @Override
    protected void onBeginWholeObject(long streamPosition, int type, long inflatedSize) throws IOException {
        this.crc.reset();
    }

    @Override
    protected void onObjectHeader(PackParser.Source src, byte[] raw, int pos, int len) throws IOException {
        this.crc.update(raw, pos, len);
    }

    @Override
    protected void onObjectData(PackParser.Source src, byte[] raw, int pos, int len) throws IOException {
        this.crc.update(raw, pos, len);
    }

    @Override
    protected void onEndWholeObject(PackedObjectInfo info) throws IOException {
        info.setCRC((int)this.crc.getValue());
    }

    @Override
    protected void onBeginOfsDelta(long deltaStreamPosition, long baseStreamPosition, long inflatedSize) throws IOException {
        this.crc.reset();
    }

    @Override
    protected void onBeginRefDelta(long deltaStreamPosition, AnyObjectId baseId, long inflatedSize) throws IOException {
        this.crc.reset();
    }

    @Override
    protected PackParser.UnresolvedDelta onEndDelta() throws IOException {
        PackParser.UnresolvedDelta delta = new PackParser.UnresolvedDelta();
        delta.setCRC((int)this.crc.getValue());
        return delta;
    }

    @Override
    protected void onInflatedObjectData(PackedObjectInfo obj, int typeCode, byte[] data) throws IOException {
    }

    @Override
    protected void verifySafeObject(AnyObjectId id, int type, byte[] data) {
        try {
            super.verifySafeObject(id, type, data);
        }
        catch (CorruptObjectException e) {
            this.corruptObjects.add(new FsckError.CorruptObject(id.toObjectId(), type, e.getErrorType()));
        }
    }

    @Override
    protected void onPackFooter(byte[] hash) throws IOException {
    }

    @Override
    protected boolean onAppendBase(int typeCode, byte[] data, PackedObjectInfo info) throws IOException {
        return false;
    }

    @Override
    protected void onEndThinPack() throws IOException {
    }

    @Override
    protected PackParser.ObjectTypeAndSize seekDatabase(PackedObjectInfo obj, PackParser.ObjectTypeAndSize info) throws IOException {
        this.crc.reset();
        this.offset = obj.getOffset();
        return this.readObjectHeader(info);
    }

    @Override
    protected PackParser.ObjectTypeAndSize seekDatabase(PackParser.UnresolvedDelta delta, PackParser.ObjectTypeAndSize info) throws IOException {
        this.crc.reset();
        this.offset = delta.getOffset();
        return this.readObjectHeader(info);
    }

    @Override
    protected int readDatabase(byte[] dst, int pos, int cnt) throws IOException {
        int n = this.read(this.offset, dst, pos, cnt);
        if (n > 0) {
            this.offset += (long)n;
        }
        return n;
    }

    int read(long channelPosition, byte[] dst, int pos, int cnt) throws IOException {
        long block = channelPosition / (long)this.blockSize;
        byte[] bytes = this.readFromChannel(block);
        if (bytes == null) {
            return -1;
        }
        int offs = (int)(channelPosition - block * (long)this.blockSize);
        int bytesToCopy = Math.min(cnt, bytes.length - offs);
        if (bytesToCopy < 1) {
            return -1;
        }
        System.arraycopy(bytes, offs, dst, pos, bytesToCopy);
        return bytesToCopy;
    }

    private byte[] readFromChannel(long block) throws IOException {
        this.channel.position(block * (long)this.blockSize);
        ByteBuffer buf = ByteBuffer.allocate(this.blockSize);
        int totalBytesRead = 0;
        while (totalBytesRead < this.blockSize) {
            int bytesRead = this.channel.read(buf);
            if (bytesRead == -1) {
                if (totalBytesRead == 0) {
                    return null;
                }
                return Arrays.copyOf(buf.array(), totalBytesRead);
            }
            totalBytesRead += bytesRead;
        }
        return buf.array();
    }

    @Override
    protected boolean checkCRC(int oldCRC) {
        return oldCRC == (int)this.crc.getValue();
    }

    @Override
    protected void onStoreStream(byte[] raw, int pos, int len) throws IOException {
    }

    public Set<FsckError.CorruptObject> getCorruptObjects() {
        return this.corruptObjects;
    }

    public void verifyIndex(PackIndex idx) throws CorruptPackIndexException {
        ObjectIdOwnerMap inPack = new ObjectIdOwnerMap();
        int i = 0;
        while (i < this.getObjectCount()) {
            PackedObjectInfo entry = this.getObject(i);
            inPack.add(new ObjFromPack(entry));
            long offs = idx.findOffset(entry);
            if (offs == -1L) {
                throw new CorruptPackIndexException(MessageFormat.format(JGitText.get().missingObject, entry.getType(), entry.getName()), CorruptPackIndexException.ErrorType.MISSING_OBJ);
            }
            if (offs != entry.getOffset()) {
                throw new CorruptPackIndexException(MessageFormat.format(JGitText.get().mismatchOffset, entry.getName()), CorruptPackIndexException.ErrorType.MISMATCH_OFFSET);
            }
            try {
                if (idx.hasCRC32Support() && (int)idx.findCRC32(entry) != entry.getCRC()) {
                    throw new CorruptPackIndexException(MessageFormat.format(JGitText.get().mismatchCRC, entry.getName()), CorruptPackIndexException.ErrorType.MISMATCH_CRC);
                }
            }
            catch (MissingObjectException e) {
                CorruptPackIndexException cpe = new CorruptPackIndexException(MessageFormat.format(JGitText.get().missingCRC, entry.getName()), CorruptPackIndexException.ErrorType.MISSING_CRC);
                cpe.initCause(e);
                throw cpe;
            }
            ++i;
        }
        for (PackIndex.MutableEntry entry : idx) {
            if (inPack.contains(entry.toObjectId())) continue;
            throw new CorruptPackIndexException(MessageFormat.format(JGitText.get().unknownObjectInIndex, entry.name()), CorruptPackIndexException.ErrorType.UNKNOWN_OBJ);
        }
    }

    public void overwriteObjectCount(long objectCount) {
        this.expectedObjectCount = objectCount;
    }

    static class ObjFromPack
    extends ObjectIdOwnerMap.Entry {
        ObjFromPack(AnyObjectId id) {
            super(id);
        }
    }
}

