/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.gpg.bc.internal.keys;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPUtil;
import shadow.org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import shadow.org.bouncycastle.util.Arrays;
import shadow.org.eclipse.jgit.gpg.bc.internal.BCText;

class OCBPBEProtectionRemoverFactory
implements PBEProtectionRemoverFactory {
    private final PGPDigestCalculatorProvider calculatorProvider;
    private final char[] passphrase;
    private final byte[] aad;

    OCBPBEProtectionRemoverFactory(char[] passphrase, PGPDigestCalculatorProvider calculatorProvider, byte[] aad) {
        this.calculatorProvider = calculatorProvider;
        this.passphrase = passphrase;
        this.aad = aad;
    }

    @Override
    public PBESecretKeyDecryptor createDecryptor(String protection) throws PGPException {
        return new PBESecretKeyDecryptor(this.passphrase, this.calculatorProvider){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public byte[] recoverKeyData(int encAlgorithm, byte[] key, byte[] iv, byte[] encrypted, int encryptedOffset, int encryptedLength) throws PGPException {
                byte[] byArray;
                block8: {
                    String algorithmName = PGPUtil.getSymmetricCipherName(encAlgorithm);
                    byte[] decrypted = null;
                    try {
                        Cipher c = Cipher.getInstance(String.valueOf(algorithmName) + "/OCB/NoPadding");
                        SecretKeySpec secretKey = new SecretKeySpec(key, algorithmName);
                        c.init(2, (Key)secretKey, new IvParameterSpec(iv));
                        c.updateAAD(OCBPBEProtectionRemoverFactory.this.aad);
                        decrypted = new byte[c.getOutputSize(encryptedLength)];
                        int decryptedLength = c.update(encrypted, encryptedOffset, encryptedLength, decrypted);
                        decryptedLength += c.doFinal(decrypted, decryptedLength);
                        if (decryptedLength != decrypted.length) {
                            throw new PGPException(MessageFormat.format(BCText.get().cryptWrongDecryptedLength, decryptedLength, decrypted.length));
                        }
                        byte[] result = decrypted;
                        decrypted = null;
                        byArray = result;
                        if (decrypted == null) break block8;
                    }
                    catch (NoClassDefFoundError e) {
                        try {
                            String msg = MessageFormat.format(BCText.get().gpgNoSuchAlgorithm, String.valueOf(algorithmName) + "/OCB");
                            throw new PGPException(msg, new NoSuchAlgorithmException(msg, e));
                            catch (PGPException e2) {
                                throw e2;
                            }
                            catch (Exception e3) {
                                throw new PGPException(MessageFormat.format(BCText.get().cryptCipherError, e3.getLocalizedMessage()), e3);
                            }
                        }
                        catch (Throwable throwable) {
                            if (decrypted != null) {
                                Arrays.fill(decrypted, (byte)0);
                            }
                            throw throwable;
                        }
                    }
                    Arrays.fill(decrypted, (byte)0);
                }
                return byArray;
            }
        };
    }
}

