/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.gpg.bc.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.util.Iterator;
import shadow.org.bouncycastle.bcpg.ArmoredOutputStream;
import shadow.org.bouncycastle.bcpg.BCPGOutputStream;
import shadow.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.PGPSecretKey;
import shadow.org.bouncycastle.openpgp.PGPSignatureGenerator;
import shadow.org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import shadow.org.eclipse.jgit.annotations.NonNull;
import shadow.org.eclipse.jgit.annotations.Nullable;
import shadow.org.eclipse.jgit.api.errors.CanceledException;
import shadow.org.eclipse.jgit.api.errors.JGitInternalException;
import shadow.org.eclipse.jgit.api.errors.UnsupportedSigningFormatException;
import shadow.org.eclipse.jgit.errors.UnsupportedCredentialItem;
import shadow.org.eclipse.jgit.gpg.bc.internal.BCText;
import shadow.org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKey;
import shadow.org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKeyLocator;
import shadow.org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKeyPassphrasePrompt;
import shadow.org.eclipse.jgit.internal.JGitText;
import shadow.org.eclipse.jgit.lib.CommitBuilder;
import shadow.org.eclipse.jgit.lib.GpgConfig;
import shadow.org.eclipse.jgit.lib.GpgObjectSigner;
import shadow.org.eclipse.jgit.lib.GpgSignature;
import shadow.org.eclipse.jgit.lib.GpgSigner;
import shadow.org.eclipse.jgit.lib.ObjectBuilder;
import shadow.org.eclipse.jgit.lib.PersonIdent;
import shadow.org.eclipse.jgit.transport.CredentialsProvider;
import shadow.org.eclipse.jgit.util.StringUtils;

public class BouncyCastleGpgSigner
extends GpgSigner
implements GpgObjectSigner {
    private static void registerBouncyCastleProviderIfNecessary() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public BouncyCastleGpgSigner() {
        BouncyCastleGpgSigner.registerBouncyCastleProviderIfNecessary();
    }

    @Override
    public boolean canLocateSigningKey(@Nullable String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        try {
            return this.canLocateSigningKey(gpgSigningKey, committer, credentialsProvider, null);
        }
        catch (UnsupportedSigningFormatException e) {
            return false;
        }
    }

    @Override
    public boolean canLocateSigningKey(@Nullable String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider, GpgConfig config) throws CanceledException, UnsupportedSigningFormatException {
        if (config != null && config.getKeyFormat() != GpgConfig.GpgFormat.OPENPGP) {
            throw new UnsupportedSigningFormatException(JGitText.get().onlyOpenPgpSupportedForSigning);
        }
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt = new BouncyCastleGpgKeyPassphrasePrompt(credentialsProvider);){
                BouncyCastleGpgKey gpgKey = this.locateSigningKey(gpgSigningKey, committer, passphrasePrompt);
                boolean bl = gpgKey != null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CanceledException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
    }

    private BouncyCastleGpgKey locateSigningKey(@Nullable String gpgSigningKey, PersonIdent committer, BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt) throws CanceledException, UnsupportedCredentialItem, IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, URISyntaxException {
        if (gpgSigningKey == null || gpgSigningKey.isEmpty()) {
            gpgSigningKey = String.valueOf('<') + committer.getEmailAddress() + '>';
        }
        BouncyCastleGpgKeyLocator keyHelper = new BouncyCastleGpgKeyLocator(gpgSigningKey, passphrasePrompt);
        return keyHelper.findSecretKey();
    }

    @Override
    public void sign(@NonNull CommitBuilder commit, @Nullable String gpgSigningKey, @NonNull PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        try {
            this.signObject(commit, gpgSigningKey, committer, credentialsProvider, null);
        }
        catch (UnsupportedSigningFormatException unsupportedSigningFormatException) {
            // empty catch block
        }
    }

    @Override
    public void signObject(@NonNull ObjectBuilder object, @Nullable String gpgSigningKey, @NonNull PersonIdent committer, CredentialsProvider credentialsProvider, GpgConfig config) throws CanceledException, UnsupportedSigningFormatException {
        if (config != null && config.getKeyFormat() != GpgConfig.GpgFormat.OPENPGP) {
            throw new UnsupportedSigningFormatException(JGitText.get().onlyOpenPgpSupportedForSigning);
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt = new BouncyCastleGpgKeyPassphrasePrompt(credentialsProvider);){
                String keyUserId;
                BouncyCastleGpgKey gpgKey = this.locateSigningKey(gpgSigningKey, committer, passphrasePrompt);
                PGPSecretKey secretKey = gpgKey.getSecretKey();
                if (secretKey == null) {
                    throw new JGitInternalException(BCText.get().unableToSignCommitNoSecretKey);
                }
                JcePBESecretKeyDecryptorBuilder decryptorBuilder = new JcePBESecretKeyDecryptorBuilder().setProvider("BC");
                PGPPrivateKey privateKey = null;
                if (!passphrasePrompt.hasPassphrase()) {
                    try {
                        privateKey = secretKey.extractPrivateKey(decryptorBuilder.build(new char[0]));
                    }
                    catch (PGPException pGPException) {
                        // empty catch block
                    }
                }
                if (privateKey == null) {
                    char[] passphrase = passphrasePrompt.getPassphrase(secretKey.getPublicKey().getFingerprint(), gpgKey.getOrigin());
                    privateKey = secretKey.extractPrivateKey(decryptorBuilder.build(passphrase));
                }
                PGPPublicKey publicKey = secretKey.getPublicKey();
                PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(publicKey.getAlgorithm(), 8).setProvider("BC"));
                signatureGenerator.init(0, privateKey);
                PGPSignatureSubpacketGenerator subpackets = new PGPSignatureSubpacketGenerator();
                subpackets.setIssuerFingerprint(false, publicKey);
                String userId = committer.getEmailAddress();
                Iterator<String> userIds = publicKey.getUserIDs();
                if (!(!userIds.hasNext() || StringUtils.isEmptyOrNull(keyUserId = userIds.next()) || userId != null && keyUserId.contains(userId))) {
                    userId = BouncyCastleGpgSigner.extractSignerId(keyUserId);
                }
                if (userId != null) {
                    subpackets.setSignerUserID(false, userId);
                }
                signatureGenerator.setHashedSubpackets(subpackets.generate());
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                Throwable throwable2 = null;
                Object var20_25 = null;
                try (BCPGOutputStream out = new BCPGOutputStream(new ArmoredOutputStream(buffer));){
                    signatureGenerator.update(object.build());
                    signatureGenerator.generate().encode(out);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                object.setGpgSignature(new GpgSignature(buffer.toByteArray()));
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException | NoSuchAlgorithmException | NoSuchProviderException | PGPException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    static String extractSignerId(String pgpUserId) {
        int to;
        int from = pgpUserId.indexOf(60);
        if (from >= 0 && (to = pgpUserId.indexOf(62, from + 1)) > from + 1) {
            return pgpUserId.substring(from + 1, to);
        }
        return pgpUserId;
    }
}

