/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.gpg.bc.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import shadow.org.bouncycastle.gpg.keybox.BlobType;
import shadow.org.bouncycastle.gpg.keybox.KeyBlob;
import shadow.org.bouncycastle.gpg.keybox.KeyBox;
import shadow.org.bouncycastle.gpg.keybox.KeyInformation;
import shadow.org.bouncycastle.gpg.keybox.PublicKeyRingBlob;
import shadow.org.bouncycastle.gpg.keybox.UserID;
import shadow.org.bouncycastle.gpg.keybox.jcajce.JcaKeyBox;
import shadow.org.bouncycastle.gpg.keybox.jcajce.JcaKeyBoxBuilder;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import shadow.org.bouncycastle.openpgp.PGPSecretKey;
import shadow.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import shadow.org.bouncycastle.openpgp.PGPSignature;
import shadow.org.bouncycastle.openpgp.PGPUtil;
import shadow.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import shadow.org.bouncycastle.util.encoders.Hex;
import shadow.org.eclipse.jgit.annotations.NonNull;
import shadow.org.eclipse.jgit.api.errors.CanceledException;
import shadow.org.eclipse.jgit.errors.UnsupportedCredentialItem;
import shadow.org.eclipse.jgit.gpg.bc.internal.BCText;
import shadow.org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKey;
import shadow.org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKeyPassphrasePrompt;
import shadow.org.eclipse.jgit.gpg.bc.internal.keys.KeyGrip;
import shadow.org.eclipse.jgit.gpg.bc.internal.keys.SecretKeys;
import shadow.org.eclipse.jgit.util.FS;
import shadow.org.eclipse.jgit.util.StringUtils;
import shadow.org.eclipse.jgit.util.SystemReader;
import shadow.org.slf4j.Logger;
import shadow.org.slf4j.LoggerFactory;

public class BouncyCastleGpgKeyLocator {
    private static final Logger log = LoggerFactory.getLogger(BouncyCastleGpgKeyLocator.class);
    static final Path GPG_DIRECTORY = BouncyCastleGpgKeyLocator.findGpgDirectory();
    private static final Path USER_KEYBOX_PATH = GPG_DIRECTORY.resolve("pubring.kbx");
    private static final Path USER_SECRET_KEY_DIR = GPG_DIRECTORY.resolve("private-keys-v1.d");
    private static final Path USER_PGP_PUBRING_FILE = GPG_DIRECTORY.resolve("pubring.gpg");
    private static final Path USER_PGP_LEGACY_SECRING_FILE = GPG_DIRECTORY.resolve("secring.gpg");
    private final String signingKey;
    private BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt;

    private static Path findGpgDirectory() {
        File home;
        String appData;
        SystemReader system = SystemReader.getInstance();
        if (system.isWindows() && (appData = system.getenv("APPDATA")) != null && !appData.isEmpty()) {
            try {
                Path directory = Paths.get(appData, new String[0]).resolve("gnupg");
                if (Files.isDirectory(directory, new LinkOption[0])) {
                    return directory;
                }
            }
            catch (SecurityException | InvalidPathException runtimeException) {
                // empty catch block
            }
        }
        if ((home = FS.DETECTED.userHome()) == null) {
            home = new File(".").getAbsoluteFile();
        }
        return home.toPath().resolve(".gnupg");
    }

    public BouncyCastleGpgKeyLocator(String signingKey, @NonNull BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt) {
        this.signingKey = signingKey;
        this.passphrasePrompt = passphrasePrompt;
    }

    private PGPSecretKey attemptParseSecretKey(Path keyFile, PGPDigestCalculatorProvider calculatorProvider, SecretKeys.PassphraseSupplier passphraseSupplier, PGPPublicKey publicKey) throws IOException, PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream in = Files.newInputStream(keyFile, new OpenOption[0]);){
            return SecretKeys.readSecretKey(in, calculatorProvider, passphraseSupplier, publicKey);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static boolean containsSigningKey(String userId, String signingKeySpec) {
        if (StringUtils.isEmptyOrNull(userId) || StringUtils.isEmptyOrNull(signingKeySpec)) {
            return false;
        }
        String toMatch = signingKeySpec;
        if (toMatch.startsWith("0x") && toMatch.trim().length() > 2) {
            return false;
        }
        char command = toMatch.charAt(0);
        switch (command) {
            case '*': 
            case '<': 
            case '=': 
            case '@': {
                toMatch = toMatch.substring(1);
                if (!toMatch.isEmpty()) break;
                return false;
            }
        }
        switch (command) {
            case '=': {
                return userId.equals(toMatch);
            }
            case '<': {
                int begin = userId.indexOf(60);
                int end = userId.indexOf(62, begin + 1);
                int stop = toMatch.indexOf(62);
                return begin >= 0 && end > begin + 1 && stop > 0 && userId.substring(begin + 1, end).equalsIgnoreCase(toMatch.substring(0, stop));
            }
            case '@': {
                int begin = userId.indexOf(60);
                int end = userId.indexOf(62, begin + 1);
                return begin >= 0 && end > begin + 1 && BouncyCastleGpgKeyLocator.containsIgnoreCase(userId.substring(begin + 1, end), toMatch);
            }
        }
        if (toMatch.trim().isEmpty()) {
            return false;
        }
        return BouncyCastleGpgKeyLocator.containsIgnoreCase(userId, toMatch);
    }

    private static boolean containsIgnoreCase(String a, String b) {
        int alength = a.length();
        int blength = b.length();
        int i = 0;
        while (i + blength <= alength) {
            if (a.regionMatches(true, i, b, 0, blength)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String toFingerprint(String keyId) {
        if (keyId.startsWith("0x")) {
            return keyId.substring(2);
        }
        return keyId;
    }

    static PGPPublicKey findPublicKey(String fingerprint, String keySpec) throws IOException, PGPException {
        PGPPublicKey result = BouncyCastleGpgKeyLocator.findPublicKeyInPubring(USER_PGP_PUBRING_FILE, fingerprint, keySpec);
        if (result == null && Files.exists(USER_KEYBOX_PATH, new LinkOption[0])) {
            try {
                result = BouncyCastleGpgKeyLocator.findPublicKeyInKeyBox(USER_KEYBOX_PATH, fingerprint, keySpec);
            }
            catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | NoOpenPgpKeyException e) {
                log.error(e.getMessage(), e);
            }
        }
        return result;
    }

    private static PGPPublicKey findPublicKeyByKeyId(KeyBlob keyBlob, String keyId) throws IOException {
        if (keyId.isEmpty()) {
            return null;
        }
        for (KeyInformation keyInfo : keyBlob.getKeyInformation()) {
            String fingerprint = Hex.toHexString(keyInfo.getFingerprint()).toLowerCase(Locale.ROOT);
            if (!fingerprint.endsWith(keyId)) continue;
            return BouncyCastleGpgKeyLocator.getPublicKey(keyBlob, keyInfo.getFingerprint());
        }
        return null;
    }

    private static PGPPublicKey findPublicKeyByUserId(KeyBlob keyBlob, String keySpec) throws IOException {
        for (UserID userID : keyBlob.getUserIds()) {
            if (!BouncyCastleGpgKeyLocator.containsSigningKey(userID.getUserIDAsString(), keySpec)) continue;
            return BouncyCastleGpgKeyLocator.getSigningPublicKey(keyBlob);
        }
        return null;
    }

    private static PGPPublicKey findPublicKeyInKeyBox(Path keyboxFile, String keyId, String keySpec) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, NoOpenPgpKeyException {
        KeyBox keyBox = BouncyCastleGpgKeyLocator.readKeyBoxFile(keyboxFile);
        String id = keyId != null ? keyId : BouncyCastleGpgKeyLocator.toFingerprint(keySpec).toLowerCase(Locale.ROOT);
        boolean hasOpenPgpKey = false;
        for (KeyBlob keyBlob : keyBox.getKeyBlobs()) {
            if (keyBlob.getType() != BlobType.OPEN_PGP_BLOB) continue;
            hasOpenPgpKey = true;
            PGPPublicKey key = BouncyCastleGpgKeyLocator.findPublicKeyByKeyId(keyBlob, id);
            if (key != null) {
                return key;
            }
            key = BouncyCastleGpgKeyLocator.findPublicKeyByUserId(keyBlob, keySpec);
            if (key == null) continue;
            return key;
        }
        if (!hasOpenPgpKey) {
            throw new NoOpenPgpKeyException();
        }
        return null;
    }

    @NonNull
    public BouncyCastleGpgKey findSecretKey() throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        BouncyCastleGpgKey key;
        PGPPublicKey publicKey = null;
        if (this.hasKeyFiles(USER_SECRET_KEY_DIR)) {
            block12: {
                if (Files.exists(USER_KEYBOX_PATH, new LinkOption[0])) {
                    try {
                        publicKey = BouncyCastleGpgKeyLocator.findPublicKeyInKeyBox(USER_KEYBOX_PATH, null, this.signingKey);
                        if (publicKey != null) {
                            BouncyCastleGpgKey key2 = this.findSecretKeyForKeyBoxPublicKey(publicKey, USER_KEYBOX_PATH);
                            if (key2 != null) {
                                return key2;
                            }
                            throw new PGPException(MessageFormat.format(BCText.get().gpgNoSecretKeyForPublicKey, Long.toHexString(publicKey.getKeyID())));
                        }
                        throw new PGPException(MessageFormat.format(BCText.get().gpgNoPublicKeyFound, this.signingKey));
                    }
                    catch (NoOpenPgpKeyException e) {
                        if (!log.isDebugEnabled()) break block12;
                        log.debug("{} does not contain any OpenPGP keys", (Object)USER_KEYBOX_PATH);
                    }
                }
            }
            if (Files.exists(USER_PGP_PUBRING_FILE, new LinkOption[0]) && (publicKey = BouncyCastleGpgKeyLocator.findPublicKeyInPubring(USER_PGP_PUBRING_FILE, null, this.signingKey)) != null && (key = this.findSecretKeyForKeyBoxPublicKey(publicKey, USER_PGP_PUBRING_FILE)) != null) {
                return key;
            }
            if (publicKey == null) {
                throw new PGPException(MessageFormat.format(BCText.get().gpgNoPublicKeyFound, this.signingKey));
            }
        }
        boolean hasSecring = false;
        if (Files.exists(USER_PGP_LEGACY_SECRING_FILE, new LinkOption[0])) {
            hasSecring = true;
            key = this.loadKeyFromSecring(USER_PGP_LEGACY_SECRING_FILE);
            if (key != null) {
                return key;
            }
        }
        if (publicKey != null) {
            throw new PGPException(MessageFormat.format(BCText.get().gpgNoSecretKeyForPublicKey, Long.toHexString(publicKey.getKeyID())));
        }
        if (hasSecring) {
            throw new PGPException(MessageFormat.format(BCText.get().gpgNoKeyInLegacySecring, this.signingKey));
        }
        throw new PGPException(BCText.get().gpgNoKeyring);
    }

    private boolean hasKeyFiles(Path dir) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DirectoryStream<Path> contents = Files.newDirectoryStream(dir, "*.key");){
                return contents.iterator().hasNext();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    private BouncyCastleGpgKey loadKeyFromSecring(Path secring) throws IOException, PGPException {
        PGPSecretKey secretKey = this.findSecretKeyInLegacySecring(this.signingKey, secring);
        if (secretKey != null) {
            if (!secretKey.isSigningKey()) {
                throw new PGPException(MessageFormat.format(BCText.get().gpgNotASigningKey, this.signingKey));
            }
            return new BouncyCastleGpgKey(secretKey, secring);
        }
        return null;
    }

    private BouncyCastleGpgKey findSecretKeyForKeyBoxPublicKey(PGPPublicKey publicKey, Path userKeyboxPath) throws PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        byte[] keyGrip = null;
        try {
            keyGrip = KeyGrip.getKeyGrip(publicKey);
        }
        catch (PGPException e) {
            throw new PGPException(MessageFormat.format(BCText.get().gpgNoKeygrip, Hex.toHexString(publicKey.getFingerprint())), e);
        }
        String filename = String.valueOf(Hex.toHexString(keyGrip).toUpperCase(Locale.ROOT)) + ".key";
        Path keyFile = USER_SECRET_KEY_DIR.resolve(filename);
        if (!Files.exists(keyFile, new LinkOption[0])) {
            return null;
        }
        boolean clearPrompt = false;
        try {
            PGPDigestCalculatorProvider calculatorProvider = new JcaPGPDigestCalculatorProviderBuilder().build();
            clearPrompt = true;
            PGPSecretKey secretKey = null;
            try {
                secretKey = this.attemptParseSecretKey(keyFile, calculatorProvider, () -> this.passphrasePrompt.getPassphrase(publicKey.getFingerprint(), userKeyboxPath), publicKey);
            }
            catch (PGPException e) {
                throw new PGPException(MessageFormat.format(BCText.get().gpgFailedToParseSecretKey, keyFile.toAbsolutePath()), e);
            }
            if (secretKey != null) {
                if (!secretKey.isSigningKey()) {
                    throw new PGPException(MessageFormat.format(BCText.get().gpgNotASigningKey, this.signingKey));
                }
                clearPrompt = false;
                BouncyCastleGpgKey bouncyCastleGpgKey = new BouncyCastleGpgKey(secretKey, userKeyboxPath);
                return bouncyCastleGpgKey;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            clearPrompt = false;
            return null;
        }
        catch (IOException e) {
            throw new PGPException(MessageFormat.format(BCText.get().gpgFailedToParseSecretKey, keyFile.toAbsolutePath()), e);
        }
        finally {
            if (clearPrompt) {
                this.passphrasePrompt.clear();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private PGPSecretKey findSecretKeyInLegacySecring(String signingkey, Path secringFile) throws IOException, PGPException {
        var3_3 = null;
        var4_5 = null;
        try {
            in = Files.newInputStream(secringFile, new OpenOption[0]);
            try {
                pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(new BufferedInputStream(in)), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                keyId = BouncyCastleGpgKeyLocator.toFingerprint(signingkey).toLowerCase(Locale.ROOT);
                keyrings = pgpSec.getKeyRings();
                while (true) {
                    keyRing = keyrings.next();
                    keys = keyRing.getSecretKeys();
                    while (keys.hasNext()) {
                        key = keys.next();
                        fingerprint = Hex.toHexString(key.getPublicKey().getFingerprint()).toLowerCase(Locale.ROOT);
                        if (fingerprint.endsWith(keyId)) {
                            return key;
                        }
                        userIDs = key.getUserIDs();
                        while (userIDs.hasNext()) {
                            userId = userIDs.next();
                            if (!BouncyCastleGpgKeyLocator.containsSigningKey(userId, this.signingKey)) continue;
                            return key;
                        }
                    }
                    break;
                }
            }
            finally {
                if (keyrings.hasNext()) ** continue;
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
            } else if (var3_3 != var4_6) {
                var3_3.addSuppressed(var4_6);
            }
            throw var3_3;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static PGPPublicKey findPublicKeyInPubring(Path pubringFile, String keyId, String keySpec) throws IOException, PGPException {
        try {
            var3_3 = null;
            var4_6 = null;
            try {
                in = Files.newInputStream(pubringFile, new OpenOption[0]);
                try {
                    pgpPub = new PGPPublicKeyRingCollection(new BufferedInputStream(in), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                    id = keyId != null ? keyId : BouncyCastleGpgKeyLocator.toFingerprint(keySpec).toLowerCase(Locale.ROOT);
                    keyrings = pgpPub.getKeyRings();
                    while (true) {
                        keyRing = keyrings.next();
                        keys = keyRing.getPublicKeys();
                        while (keys.hasNext()) {
                            key = keys.next();
                            fingerprint = Hex.toHexString(key.getFingerprint()).toLowerCase(Locale.ROOT);
                            if (fingerprint.endsWith(id)) {
                                return key;
                            }
                            userIDs = key.getUserIDs();
                            while (userIDs.hasNext()) {
                                userId = userIDs.next();
                                if (!BouncyCastleGpgKeyLocator.containsSigningKey(userId, keySpec)) continue;
                                return key;
                            }
                        }
                        break;
                    }
                }
                finally {
                    if (keyrings.hasNext()) ** continue;
                }
            }
            catch (Throwable var4_7) {
                if (var3_3 == null) {
                    var3_3 = var4_7;
                } else if (var3_3 != var4_7) {
                    var3_3.addSuppressed(var4_7);
                }
                throw var3_3;
            }
        }
        catch (FileNotFoundException | NoSuchFileException var3_5) {
            // empty catch block
        }
        return null;
    }

    private static PGPPublicKey getPublicKey(KeyBlob blob, byte[] fingerprint) throws IOException {
        return ((PublicKeyRingBlob)blob).getPGPPublicKeyRing().getPublicKey(fingerprint);
    }

    private static PGPPublicKey getSigningPublicKey(KeyBlob blob) throws IOException {
        PGPPublicKey masterKey = null;
        Iterator<PGPPublicKey> keys = ((PublicKeyRingBlob)blob).getPGPPublicKeyRing().getPublicKeys();
        while (keys.hasNext()) {
            PGPPublicKey key = keys.next();
            if (!BouncyCastleGpgKeyLocator.isSigningKey(key)) continue;
            if (key.isMasterKey()) {
                masterKey = key;
                continue;
            }
            return key;
        }
        return masterKey;
    }

    private static boolean isSigningKey(PGPPublicKey key) {
        Iterator signatures = key.getSignatures();
        while (signatures.hasNext()) {
            PGPSignature sig = (PGPSignature)signatures.next();
            if ((sig.getHashedSubPackets().getKeyFlags() & 2) <= 0) continue;
            return true;
        }
        return false;
    }

    private static KeyBox readKeyBoxFile(Path keyboxFile) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, NoOpenPgpKeyException {
        JcaKeyBox keyBox;
        if (keyboxFile.toFile().length() == 0L) {
            throw new NoOpenPgpKeyException();
        }
        Throwable throwable = null;
        Object var3_3 = null;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(keyboxFile, new OpenOption[0]));){
            keyBox = new JcaKeyBoxBuilder().build(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return keyBox;
    }

    private static class NoOpenPgpKeyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private NoOpenPgpKeyException() {
        }
    }
}

