/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.operator.bc;

import java.io.IOException;
import shadow.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shadow.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shadow.org.bouncycastle.crypto.ExtendedDigest;
import shadow.org.bouncycastle.crypto.Signer;
import shadow.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shadow.org.bouncycastle.crypto.signers.DSADigestSigner;
import shadow.org.bouncycastle.crypto.signers.ECDSASigner;
import shadow.org.bouncycastle.crypto.util.PublicKeyFactory;
import shadow.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import shadow.org.bouncycastle.operator.OperatorCreationException;
import shadow.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcECContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcECContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new ECDSASigner(), extendedDigest);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

