/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import shadow.org.bouncycastle.jcajce.io.OutputStreamFactory;
import shadow.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import shadow.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import shadow.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.PGPRuntimeOperationException;
import shadow.org.bouncycastle.openpgp.operator.PGPContentSigner;
import shadow.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPPrivateKey;
import shadow.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import shadow.org.bouncycastle.util.io.TeeOutputStream;

public class JcaPGPContentSignerBuilder
implements PGPContentSignerBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private int hashAlgorithm;
    private SecureRandom random;
    private int keyAlgorithm;

    public JcaPGPContentSignerBuilder(int n, int n2) {
        this.keyAlgorithm = n;
        this.hashAlgorithm = n2;
    }

    public JcaPGPContentSignerBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public JcaPGPContentSignerBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.digestCalculatorProviderBuilder.setProvider(provider);
        return this;
    }

    public JcaPGPContentSignerBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        this.digestCalculatorProviderBuilder.setProvider(string);
        return this;
    }

    public JcaPGPContentSignerBuilder setDigestProvider(Provider provider) {
        this.digestCalculatorProviderBuilder.setProvider(provider);
        return this;
    }

    public JcaPGPContentSignerBuilder setDigestProvider(String string) {
        this.digestCalculatorProviderBuilder.setProvider(string);
        return this;
    }

    public PGPContentSigner build(int n, PGPPrivateKey pGPPrivateKey) throws PGPException {
        if (pGPPrivateKey instanceof JcaPGPPrivateKey) {
            return this.build(n, pGPPrivateKey.getKeyID(), ((JcaPGPPrivateKey)pGPPrivateKey).getPrivateKey());
        }
        return this.build(n, pGPPrivateKey.getKeyID(), this.keyConverter.getPrivateKey(pGPPrivateKey));
    }

    public PGPContentSigner build(final int n, final long l, PrivateKey privateKey) throws PGPException {
        final PGPDigestCalculator pGPDigestCalculator = this.digestCalculatorProviderBuilder.build().get(this.hashAlgorithm);
        final PGPDigestCalculator pGPDigestCalculator2 = this.digestCalculatorProviderBuilder.build().get(this.hashAlgorithm);
        final Signature signature = this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
        try {
            if (this.random != null) {
                signature.initSign(privateKey, this.random);
            } else {
                signature.initSign(privateKey);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("invalid key.", invalidKeyException);
        }
        return new PGPContentSigner(){

            public int getType() {
                return n;
            }

            public int getHashAlgorithm() {
                return JcaPGPContentSignerBuilder.this.hashAlgorithm;
            }

            public int getKeyAlgorithm() {
                return JcaPGPContentSignerBuilder.this.keyAlgorithm;
            }

            public long getKeyID() {
                return l;
            }

            public OutputStream getOutputStream() {
                if (JcaPGPContentSignerBuilder.this.keyAlgorithm == 22) {
                    return new TeeOutputStream(pGPDigestCalculator2.getOutputStream(), pGPDigestCalculator.getOutputStream());
                }
                return new TeeOutputStream(OutputStreamFactory.createStream(signature), pGPDigestCalculator.getOutputStream());
            }

            public byte[] getSignature() {
                try {
                    if (JcaPGPContentSignerBuilder.this.keyAlgorithm == 22) {
                        signature.update(pGPDigestCalculator2.getDigest());
                    }
                    return signature.sign();
                }
                catch (SignatureException signatureException) {
                    throw new PGPRuntimeOperationException("Unable to create signature: " + signatureException.getMessage(), signatureException);
                }
            }

            public byte[] getDigest() {
                return pGPDigestCalculator.getDigest();
            }
        };
    }
}

