/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import shadow.org.bouncycastle.crypto.CryptoException;
import shadow.org.bouncycastle.crypto.Signer;
import shadow.org.bouncycastle.crypto.params.ParametersWithRandom;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.operator.PGPContentSigner;
import shadow.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import shadow.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import shadow.org.bouncycastle.openpgp.operator.bc.SignerOutputStream;
import shadow.org.bouncycastle.util.io.TeeOutputStream;

public class BcPGPContentSignerBuilder
implements PGPContentSignerBuilder {
    private BcPGPDigestCalculatorProvider digestCalculatorProvider = new BcPGPDigestCalculatorProvider();
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private int hashAlgorithm;
    private SecureRandom random;
    private int keyAlgorithm;

    public BcPGPContentSignerBuilder(int n, int n2) {
        this.keyAlgorithm = n;
        this.hashAlgorithm = n2;
    }

    public BcPGPContentSignerBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PGPContentSigner build(final int n, final PGPPrivateKey pGPPrivateKey) throws PGPException {
        final PGPDigestCalculator pGPDigestCalculator = this.digestCalculatorProvider.get(this.hashAlgorithm);
        final Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm);
        if (this.random != null) {
            signer.init(true, new ParametersWithRandom(this.keyConverter.getPrivateKey(pGPPrivateKey), this.random));
        } else {
            signer.init(true, this.keyConverter.getPrivateKey(pGPPrivateKey));
        }
        return new PGPContentSigner(){

            public int getType() {
                return n;
            }

            public int getHashAlgorithm() {
                return BcPGPContentSignerBuilder.this.hashAlgorithm;
            }

            public int getKeyAlgorithm() {
                return BcPGPContentSignerBuilder.this.keyAlgorithm;
            }

            public long getKeyID() {
                return pGPPrivateKey.getKeyID();
            }

            public OutputStream getOutputStream() {
                return new TeeOutputStream(new SignerOutputStream(signer), pGPDigestCalculator.getOutputStream());
            }

            public byte[] getSignature() {
                try {
                    return signer.generateSignature();
                }
                catch (CryptoException cryptoException) {
                    throw new IllegalStateException("unable to create signature");
                }
            }

            public byte[] getDigest() {
                return pGPDigestCalculator.getDigest();
            }
        };
    }
}

