/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import shadow.org.bouncycastle.bcpg.BCPGInputStream;
import shadow.org.bouncycastle.openpgp.PGPCompressedData;
import shadow.org.bouncycastle.openpgp.PGPEncryptedDataList;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPLiteralData;
import shadow.org.bouncycastle.openpgp.PGPMarker;
import shadow.org.bouncycastle.openpgp.PGPOnePassSignature;
import shadow.org.bouncycastle.openpgp.PGPOnePassSignatureList;
import shadow.org.bouncycastle.openpgp.PGPPublicKeyRing;
import shadow.org.bouncycastle.openpgp.PGPRuntimeOperationException;
import shadow.org.bouncycastle.openpgp.PGPSecretKeyRing;
import shadow.org.bouncycastle.openpgp.PGPSignature;
import shadow.org.bouncycastle.openpgp.PGPSignatureList;
import shadow.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import shadow.org.bouncycastle.util.Iterable;

public class PGPObjectFactory
implements Iterable {
    private BCPGInputStream in;
    private KeyFingerPrintCalculator fingerPrintCalculator;

    public PGPObjectFactory(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) {
        this.in = new BCPGInputStream(inputStream);
        this.fingerPrintCalculator = keyFingerPrintCalculator;
    }

    public PGPObjectFactory(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    public Object nextObject() throws IOException {
        switch (this.in.nextPacketTag()) {
            case -1: {
                return null;
            }
            case 2: {
                ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
                while (this.in.nextPacketTag() == 2) {
                    try {
                        arrayList.add(new PGPSignature(this.in));
                    }
                    catch (PGPException pGPException) {
                        throw new IOException("can't create signature object: " + pGPException);
                    }
                }
                return new PGPSignatureList(arrayList.toArray(new PGPSignature[arrayList.size()]));
            }
            case 5: {
                try {
                    return new PGPSecretKeyRing(this.in, this.fingerPrintCalculator);
                }
                catch (PGPException pGPException) {
                    throw new IOException("can't create secret key object: " + pGPException);
                }
            }
            case 6: {
                return new PGPPublicKeyRing(this.in, this.fingerPrintCalculator);
            }
            case 14: {
                try {
                    return PGPPublicKeyRing.readSubkey(this.in, this.fingerPrintCalculator);
                }
                catch (PGPException pGPException) {
                    throw new IOException("processing error: " + pGPException.getMessage());
                }
            }
            case 8: {
                return new PGPCompressedData(this.in);
            }
            case 11: {
                return new PGPLiteralData(this.in);
            }
            case 1: 
            case 3: {
                return new PGPEncryptedDataList(this.in);
            }
            case 4: {
                ArrayList<PGPOnePassSignature> arrayList = new ArrayList<PGPOnePassSignature>();
                while (this.in.nextPacketTag() == 4) {
                    try {
                        arrayList.add(new PGPOnePassSignature(this.in));
                    }
                    catch (PGPException pGPException) {
                        throw new IOException("can't create one pass signature object: " + pGPException);
                    }
                }
                return new PGPOnePassSignatureList(arrayList.toArray(new PGPOnePassSignature[arrayList.size()]));
            }
            case 10: {
                return new PGPMarker(this.in);
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return this.in.readPacket();
            }
        }
        throw new IOException("unknown object in stream: " + this.in.nextPacketTag());
    }

    public Iterator iterator() {
        return new Iterator(){
            private boolean triedNext = false;
            private Object obj = null;

            public boolean hasNext() {
                if (!this.triedNext) {
                    this.triedNext = true;
                    this.obj = this.getObject();
                }
                return this.obj != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.triedNext = false;
                return this.obj;
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot remove element from factory.");
            }

            private Object getObject() {
                try {
                    return PGPObjectFactory.this.nextObject();
                }
                catch (IOException iOException) {
                    throw new PGPRuntimeOperationException("Iterator failed to get next object: " + iOException.getMessage(), iOException);
                }
            }
        };
    }
}

