/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.gpg.keybox.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import shadow.org.bouncycastle.gpg.keybox.BlobVerifier;
import shadow.org.bouncycastle.gpg.keybox.jcajce.JcaBlobVerifier;
import shadow.org.bouncycastle.gpg.keybox.jcajce.JcaKeyBox;
import shadow.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import shadow.org.bouncycastle.jcajce.util.JcaJceHelper;
import shadow.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import shadow.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import shadow.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;

public class JcaKeyBoxBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcaKeyBoxBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcaKeyBoxBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public JcaKeyBox build(InputStream inputStream) throws NoSuchProviderException, NoSuchAlgorithmException, IOException {
        return new JcaKeyBox(inputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator(), (BlobVerifier)new JcaBlobVerifier(this.helper));
    }

    public JcaKeyBox build(byte[] byArray) throws NoSuchProviderException, NoSuchAlgorithmException, IOException {
        return new JcaKeyBox(byArray, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator(), (BlobVerifier)new JcaBlobVerifier(this.helper));
    }
}

