/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.cms;

import java.io.IOException;
import shadow.org.bouncycastle.asn1.cms.KEKIdentifier;
import shadow.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import shadow.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shadow.org.bouncycastle.cms.AuthAttributesProvider;
import shadow.org.bouncycastle.cms.CMSException;
import shadow.org.bouncycastle.cms.CMSSecureReadable;
import shadow.org.bouncycastle.cms.KEKRecipient;
import shadow.org.bouncycastle.cms.KEKRecipientId;
import shadow.org.bouncycastle.cms.Recipient;
import shadow.org.bouncycastle.cms.RecipientInformation;
import shadow.org.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

