/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.cms;

import shadow.org.bouncycastle.asn1.DEROctetString;
import shadow.org.bouncycastle.asn1.cms.KEKIdentifier;
import shadow.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import shadow.org.bouncycastle.asn1.cms.RecipientInfo;
import shadow.org.bouncycastle.cms.CMSException;
import shadow.org.bouncycastle.cms.RecipientInfoGenerator;
import shadow.org.bouncycastle.operator.GenericKey;
import shadow.org.bouncycastle.operator.OperatorException;
import shadow.org.bouncycastle.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kEKIdentifier, SymmetricKeyWrapper symmetricKeyWrapper) {
        this.kekIdentifier = kEKIdentifier;
        this.wrapper = symmetricKeyWrapper;
    }

    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        try {
            DEROctetString dEROctetString = new DEROctetString(this.wrapper.generateWrappedKey(genericKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), dEROctetString));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
    }
}

