/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import shadow.org.bouncycastle.asn1.cmp.PBMParameter;
import shadow.org.bouncycastle.asn1.crmf.PKMACValue;
import shadow.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shadow.org.bouncycastle.cert.crmf.CRMFException;
import shadow.org.bouncycastle.cert.crmf.PKMACBuilder;
import shadow.org.bouncycastle.operator.MacCalculator;
import shadow.org.bouncycastle.util.Arrays;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public boolean isValid(PKMACValue pKMACValue, char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(pKMACValue.getAlgId().getParameters()));
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return Arrays.constantTimeAreEqual(macCalculator.getMac(), pKMACValue.getValue().getBytes());
    }
}

