/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.googlecode.javaewah.symmetric;

import java.util.Comparator;
import shadow.com.googlecode.javaewah.BitmapStorage;
import shadow.com.googlecode.javaewah.EWAHCompressedBitmap;
import shadow.com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import shadow.com.googlecode.javaewah.datastructure.PriorityQ;
import shadow.com.googlecode.javaewah.symmetric.BitmapSymmetricAlgorithm;
import shadow.com.googlecode.javaewah.symmetric.EWAHPointer;
import shadow.com.googlecode.javaewah.symmetric.UpdateableBitmapFunction;

public class RunningBitmapMerge
implements BitmapSymmetricAlgorithm {
    @Override
    public void symmetric(UpdateableBitmapFunction f, BitmapStorage out, EWAHCompressedBitmap ... set) {
        out.clear();
        PriorityQ<EWAHPointer> h = new PriorityQ<EWAHPointer>(set.length, new Comparator<EWAHPointer>(){

            @Override
            public int compare(EWAHPointer arg0, EWAHPointer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        f.resize(set.length);
        for (int k = 0; k < set.length; ++k) {
            EWAHPointer x = new EWAHPointer(0, new IteratingBufferedRunningLengthWord(set[k]), k);
            if (x.hasNoData()) continue;
            f.rw[k] = x;
            x.callbackUpdate(f);
            h.toss(x);
        }
        h.buildHeap();
        int lasta = 0;
        if (h.isEmpty()) {
            return;
        }
        block1: while (true) {
            int a = h.peek().endOfRun();
            f.dispatch(out, lasta, a);
            lasta = a;
            while (true) {
                if (h.peek().endOfRun() != a) continue block1;
                EWAHPointer p = h.peek();
                p.parseNextRun();
                p.callbackUpdate(f);
                if (p.hasNoData()) {
                    h.poll();
                    if (!h.isEmpty()) continue;
                    break block1;
                }
                h.percolateDown();
            }
            break;
        }
    }
}

