/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import shadow.org.eclipse.jgit.api.Git;
import shadow.org.eclipse.jgit.api.GitCommand;
import shadow.org.eclipse.jgit.api.errors.AbortedByHookException;
import shadow.org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import shadow.org.eclipse.jgit.api.errors.EmptyCommitException;
import shadow.org.eclipse.jgit.api.errors.GitAPIException;
import shadow.org.eclipse.jgit.api.errors.JGitInternalException;
import shadow.org.eclipse.jgit.api.errors.NoFilepatternException;
import shadow.org.eclipse.jgit.api.errors.NoHeadException;
import shadow.org.eclipse.jgit.api.errors.NoMessageException;
import shadow.org.eclipse.jgit.api.errors.ServiceUnavailableException;
import shadow.org.eclipse.jgit.api.errors.UnmergedPathsException;
import shadow.org.eclipse.jgit.api.errors.UnsupportedSigningFormatException;
import shadow.org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import shadow.org.eclipse.jgit.dircache.DirCache;
import shadow.org.eclipse.jgit.dircache.DirCacheBuildIterator;
import shadow.org.eclipse.jgit.dircache.DirCacheBuilder;
import shadow.org.eclipse.jgit.dircache.DirCacheEntry;
import shadow.org.eclipse.jgit.dircache.DirCacheIterator;
import shadow.org.eclipse.jgit.errors.UnmergedPathException;
import shadow.org.eclipse.jgit.hooks.Hooks;
import shadow.org.eclipse.jgit.internal.JGitText;
import shadow.org.eclipse.jgit.lib.CommitBuilder;
import shadow.org.eclipse.jgit.lib.FileMode;
import shadow.org.eclipse.jgit.lib.GpgConfig;
import shadow.org.eclipse.jgit.lib.GpgSigner;
import shadow.org.eclipse.jgit.lib.ObjectId;
import shadow.org.eclipse.jgit.lib.ObjectInserter;
import shadow.org.eclipse.jgit.lib.PersonIdent;
import shadow.org.eclipse.jgit.lib.RefUpdate;
import shadow.org.eclipse.jgit.lib.Repository;
import shadow.org.eclipse.jgit.lib.RepositoryState;
import shadow.org.eclipse.jgit.revwalk.RevCommit;
import shadow.org.eclipse.jgit.revwalk.RevObject;
import shadow.org.eclipse.jgit.revwalk.RevTag;
import shadow.org.eclipse.jgit.revwalk.RevWalk;
import shadow.org.eclipse.jgit.transport.CredentialsProvider;
import shadow.org.eclipse.jgit.treewalk.CanonicalTreeParser;
import shadow.org.eclipse.jgit.treewalk.FileTreeIterator;
import shadow.org.eclipse.jgit.treewalk.TreeWalk;
import shadow.org.eclipse.jgit.util.ChangeIdUtil;

public class CommitCommand
extends GitCommand<RevCommit> {
    private PersonIdent author;
    private PersonIdent committer;
    private String message;
    private boolean all;
    private List<String> only = new ArrayList<String>();
    private boolean[] onlyProcessed;
    private boolean amend;
    private boolean insertChangeId;
    private List<ObjectId> parents = new LinkedList<ObjectId>();
    private String reflogComment;
    private boolean useDefaultReflogMessage = true;
    private boolean noVerify;
    private HashMap<String, PrintStream> hookOutRedirect = new HashMap(3);
    private HashMap<String, PrintStream> hookErrRedirect = new HashMap(3);
    private Boolean allowEmpty;
    private Boolean signCommit;
    private String signingKey;
    private GpgSigner gpgSigner;
    private CredentialsProvider credentialsProvider = CredentialsProvider.getDefault();
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result;

    protected CommitCommand(Repository repo) {
        super(repo);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() throws GitAPIException, AbortedByHookException, ConcurrentRefUpdateException, NoHeadException, NoMessageException, ServiceUnavailableException, UnmergedPathsException, WrongRepositoryStateException {
        this.checkCallable();
        Collections.sort(this.only);
        try {
            var1_1 = null;
            var2_5 = null;
            try {
                rw = new RevWalk(this.repo);
                try {
                    block59: {
                        block60: {
                            state = this.repo.getRepositoryState();
                            if (!state.canCommit()) {
                                throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().cannotCommitOnARepoWithState, new Object[]{state.name()}));
                            }
                            if (!this.noVerify) {
                                Hooks.preCommit(this.repo, this.hookOutRedirect.get("pre-commit"), this.hookErrRedirect.get("pre-commit")).call();
                            }
                            this.processOptions(state, rw);
                            if (this.all && !this.repo.isBare()) {
                                try {
                                    var5_9 = null;
                                    var6_12 = null;
                                    try {
                                        git = new Git(this.repo);
                                        try {
                                            git.add().addFilepattern(".").setUpdate(true).call();
                                        }
                                        finally {
                                            if (git != null) {
                                                git.close();
                                            }
                                        }
                                    }
                                    catch (Throwable var6_13) {
                                        if (var5_9 == null) {
                                            var5_9 = var6_13;
                                            throw var5_9;
                                        }
                                        if (var5_9 == var6_13) throw var5_9;
                                        var5_9.addSuppressed(var6_13);
                                        throw var5_9;
                                    }
                                }
                                catch (NoFilepatternException e) {
                                    throw new JGitInternalException(e.getMessage(), e);
                                }
                            }
                            if ((head = this.repo.exactRef("HEAD")) == null) {
                                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                            }
                            headId = this.repo.resolve("HEAD^{commit}");
                            if (headId == null && this.amend) {
                                throw new WrongRepositoryStateException(JGitText.get().commitAmendOnInitialNotPossible);
                            }
                            if (headId == null) break block59;
                            if (!this.amend) break block60;
                            previousCommit = rw.parseCommit(headId);
                            var11_15 = previousCommit.getParents();
                            var10_16 = var11_15.length;
                            var9_18 = 0;
                            if (true) ** GOTO lbl60
                        }
                        this.parents.add(0, headId);
                        break block59;
                        do {
                            p = var11_15[var9_18];
                            this.parents.add(p.getId());
                            ++var9_18;
lbl60:
                            // 2 sources

                        } while (var9_18 < var10_16);
                        if (this.author == null) {
                            this.author = previousCommit.getAuthorIdent();
                        }
                    }
                    if (!this.noVerify) {
                        this.message = Hooks.commitMsg(this.repo, this.hookOutRedirect.get("commit-msg"), this.hookErrRedirect.get("commit-msg")).setCommitMessage(this.message).call();
                    }
                    index = this.repo.lockDirCache();
                    try {
                        var8_21 = null;
                        var9_19 = null;
                        try {
                            odi = this.repo.newObjectInserter();
                            try {
                                if (!this.only.isEmpty()) {
                                    index = this.createTemporaryIndex(headId, index, rw);
                                }
                                indexTreeId = index.writeTree(odi);
                                if (this.insertChangeId) {
                                    this.insertChangeId(indexTreeId);
                                }
                                if (headId != null && !this.allowEmpty.booleanValue()) {
                                    headCommit = rw.parseCommit(headId);
                                    headCommit.getTree();
                                    if (indexTreeId.equals(headCommit.getTree())) {
                                        throw new EmptyCommitException(JGitText.get().emptyCommit);
                                    }
                                }
                                commit = new CommitBuilder();
                                commit.setCommitter(this.committer);
                                commit.setAuthor(this.author);
                                commit.setMessage(this.message);
                                commit.setParentIds(this.parents);
                                commit.setTreeId(indexTreeId);
                                if (this.signCommit.booleanValue()) {
                                    if (this.gpgSigner == null) {
                                        throw new ServiceUnavailableException(JGitText.get().signingServiceUnavailable);
                                    }
                                    this.gpgSigner.sign(commit, this.signingKey, this.committer, this.credentialsProvider);
                                }
                                commitId = odi.insert(commit);
                                odi.flush();
                                revCommit = rw.parseCommit(commitId);
                                ru = this.repo.updateRef("HEAD");
                                ru.setNewObjectId(commitId);
                                if (!this.useDefaultReflogMessage) {
                                    ru.setRefLogMessage(this.reflogComment, false);
                                } else {
                                    prefix = this.amend != false ? "commit (amend): " : (this.parents.isEmpty() != false ? "commit (initial): " : "commit: ");
                                    ru.setRefLogMessage(String.valueOf(prefix) + revCommit.getShortMessage(), false);
                                }
                                if (headId != null) {
                                    ru.setExpectedOldObjectId(headId);
                                } else {
                                    ru.setExpectedOldObjectId(ObjectId.zeroId());
                                }
                                rc = ru.forceUpdate();
                                switch (CommitCommand.$SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result()[rc.ordinal()]) {
                                    case 4: 
                                    case 5: 
                                    case 6: {
                                        this.setCallable(false);
                                        if (state == RepositoryState.MERGING_RESOLVED || this.isMergeDuringRebase(state)) {
                                            this.repo.writeMergeCommitMsg(null);
                                            this.repo.writeMergeHeads(null);
                                        } else if (state == RepositoryState.CHERRY_PICKING_RESOLVED) {
                                            this.repo.writeMergeCommitMsg(null);
                                            this.repo.writeCherryPickHead(null);
                                        } else if (state == RepositoryState.REVERTING_RESOLVED) {
                                            this.repo.writeMergeCommitMsg(null);
                                            this.repo.writeRevertHead(null);
                                        }
                                        Hooks.postCommit(this.repo, this.hookOutRedirect.get("post-commit"), this.hookErrRedirect.get("post-commit")).call();
                                        var18_28 = revCommit;
                                        if (odi == null) return var18_28;
                                        odi.close();
                                        return var18_28;
                                    }
                                    case 2: 
                                    case 7: {
                                        throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                                    }
                                }
                                throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", commitId.toString(), rc}));
                            }
                            catch (Throwable var8_22) {
                                if (odi == null) throw var8_22;
                                odi.close();
                                throw var8_22;
                            }
                        }
                        catch (Throwable var9_20) {
                            if (var8_21 == null) {
                                var8_21 = var9_20;
                                throw var8_21;
                            }
                            if (var8_21 == var9_20) throw var8_21;
                            var8_21.addSuppressed(var9_20);
                            throw var8_21;
                        }
                    }
                    finally {
                        index.unlock();
                    }
                }
                finally {
                    if (rw != null) {
                        rw.close();
                    }
                }
            }
            catch (Throwable var2_6) {
                if (var1_1 == null) {
                    var1_1 = var2_6;
                    throw var1_1;
                }
                if (var1_1 == var2_6) throw var1_1;
                var1_1.addSuppressed(var2_6);
                throw var1_1;
            }
        }
        catch (UnmergedPathException e) {
            throw new UnmergedPathsException(e);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfCommitCommand, e);
        }
    }

    private void insertChangeId(ObjectId treeId) {
        ObjectId firstParentId = null;
        if (!this.parents.isEmpty()) {
            firstParentId = this.parents.get(0);
        }
        ObjectId changeId = ChangeIdUtil.computeChangeId(treeId, firstParentId, this.author, this.committer, this.message);
        this.message = ChangeIdUtil.insertId(this.message, changeId);
        if (changeId != null) {
            this.message = this.message.replaceAll("\nChange-Id: I" + ObjectId.zeroId().getName() + "\n", "\nChange-Id: I" + changeId.getName() + "\n");
        }
    }

    private DirCache createTemporaryIndex(ObjectId headId, DirCache index, RevWalk rw) throws IOException {
        ObjectInserter inserter = null;
        DirCacheBuilder existingBuilder = index.builder();
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheBuilder tempBuilder = inCoreIndex.builder();
        this.onlyProcessed = new boolean[this.only.size()];
        boolean emptyCommit = true;
        Throwable throwable = null;
        Object var10_12 = null;
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            treeWalk.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
            int dcIdx = treeWalk.addTree(new DirCacheBuildIterator(existingBuilder));
            FileTreeIterator fti = new FileTreeIterator(this.repo);
            fti.setDirCacheIterator(treeWalk, 0);
            int fIdx = treeWalk.addTree(fti);
            int hIdx = -1;
            if (headId != null) {
                hIdx = treeWalk.addTree(rw.parseTree(headId));
            }
            treeWalk.setRecursive(true);
            String lastAddedFile = null;
            while (treeWalk.next()) {
                String path = treeWalk.getPathString();
                int pos = this.lookupOnly(path);
                CanonicalTreeParser hTree = null;
                if (hIdx != -1) {
                    hTree = treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                }
                DirCacheIterator dcTree = treeWalk.getTree(dcIdx, DirCacheIterator.class);
                if (pos >= 0) {
                    boolean tracked;
                    FileTreeIterator fTree = treeWalk.getTree(fIdx, FileTreeIterator.class);
                    boolean bl = tracked = dcTree != null || hTree != null;
                    if (!tracked || path.equals(lastAddedFile)) continue;
                    lastAddedFile = path;
                    if (fTree != null) {
                        boolean objectExists;
                        DirCacheEntry dcEntry = new DirCacheEntry(path);
                        long entryLength = fTree.getEntryLength();
                        dcEntry.setLength(entryLength);
                        dcEntry.setLastModified(fTree.getEntryLastModifiedInstant());
                        dcEntry.setFileMode(fTree.getIndexFileMode(dcTree));
                        boolean bl2 = objectExists = dcTree != null && fTree.idEqual(dcTree) || hTree != null && fTree.idEqual(hTree);
                        if (objectExists) {
                            dcEntry.setObjectId(fTree.getEntryObjectId());
                        } else if (FileMode.GITLINK.equals(dcEntry.getFileMode())) {
                            dcEntry.setObjectId(fTree.getEntryObjectId());
                        } else {
                            if (inserter == null) {
                                inserter = this.repo.newObjectInserter();
                            }
                            long contentLength = fTree.getEntryContentLength();
                            Throwable throwable2 = null;
                            Object var30_32 = null;
                            try (InputStream inputStream = fTree.openEntryStream();){
                                dcEntry.setObjectId(inserter.insert(3, contentLength, inputStream));
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        existingBuilder.add(dcEntry);
                        tempBuilder.add(dcEntry);
                        if (emptyCommit && (hTree == null || !hTree.idEqual(fTree) || hTree.getEntryRawMode() != fTree.getEntryRawMode())) {
                            emptyCommit = false;
                        }
                    } else if (emptyCommit && hTree != null) {
                        emptyCommit = false;
                    }
                    this.onlyProcessed[pos] = true;
                    continue;
                }
                if (hTree != null) {
                    DirCacheEntry dcEntry = new DirCacheEntry(path);
                    dcEntry.setObjectId(hTree.getEntryObjectId());
                    dcEntry.setFileMode(hTree.getEntryFileMode());
                    tempBuilder.add(dcEntry);
                }
                if (dcTree == null) continue;
                existingBuilder.add(dcTree.getDirCacheEntry());
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        int i = 0;
        while (i < this.onlyProcessed.length) {
            if (!this.onlyProcessed[i]) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().entryNotFoundByPath, this.only.get(i)));
            }
            ++i;
        }
        if (emptyCommit && !this.allowEmpty.booleanValue()) {
            throw new JGitInternalException(JGitText.get().emptyCommit);
        }
        existingBuilder.commit();
        tempBuilder.finish();
        return inCoreIndex;
    }

    private int lookupOnly(String pathString) {
        String p = pathString;
        while (true) {
            int position;
            if ((position = Collections.binarySearch(this.only, p)) >= 0) {
                return position;
            }
            int l = p.lastIndexOf(47);
            if (l < 1) break;
            p = p.substring(0, l);
        }
        return -1;
    }

    private void processOptions(RepositoryState state, RevWalk rw) throws NoMessageException, UnsupportedSigningFormatException {
        if (this.committer == null) {
            this.committer = new PersonIdent(this.repo);
        }
        if (this.author == null && !this.amend) {
            this.author = this.committer;
        }
        if (this.allowEmpty == null) {
            Boolean bl = this.allowEmpty = this.only.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (state == RepositoryState.MERGING_RESOLVED || this.isMergeDuringRebase(state)) {
            try {
                this.parents = this.repo.readMergeHeads();
                if (this.parents != null) {
                    int i = 0;
                    while (i < this.parents.size()) {
                        RevObject ro = rw.parseAny(this.parents.get(i));
                        if (ro instanceof RevTag) {
                            this.parents.set(i, rw.peel(ro));
                        }
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_HEAD", e), e);
            }
            if (this.message == null) {
                try {
                    this.message = this.repo.readMergeCommitMsg();
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_MSG", e), e);
                }
            }
        } else if (state == RepositoryState.SAFE && this.message == null) {
            try {
                this.message = this.repo.readSquashCommitMsg();
                if (this.message != null) {
                    this.repo.writeSquashCommitMsg(null);
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_MSG", e), e);
            }
        }
        if (this.message == null) {
            throw new NoMessageException(JGitText.get().commitMessageNotSpecified);
        }
        GpgConfig gpgConfig = new GpgConfig(this.repo.getConfig());
        if (this.signCommit == null) {
            Boolean bl = this.signCommit = gpgConfig.isSignCommits() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.signingKey == null) {
            this.signingKey = gpgConfig.getSigningKey();
        }
        if (this.gpgSigner == null) {
            if (gpgConfig.getKeyFormat() != GpgConfig.GpgFormat.OPENPGP) {
                throw new UnsupportedSigningFormatException(JGitText.get().onlyOpenPgpSupportedForSigning);
            }
            this.gpgSigner = GpgSigner.getDefault();
        }
    }

    private boolean isMergeDuringRebase(RepositoryState state) {
        if (state != RepositoryState.REBASING_INTERACTIVE && state != RepositoryState.REBASING_MERGE) {
            return false;
        }
        try {
            return this.repo.readMergeHeads() != null;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_HEAD", e), e);
        }
    }

    public CommitCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public CommitCommand setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public CommitCommand setCommitter(PersonIdent committer) {
        this.checkCallable();
        this.committer = committer;
        return this;
    }

    public CommitCommand setCommitter(String name, String email) {
        this.checkCallable();
        return this.setCommitter(new PersonIdent(name, email));
    }

    public PersonIdent getCommitter() {
        return this.committer;
    }

    public CommitCommand setAuthor(PersonIdent author) {
        this.checkCallable();
        this.author = author;
        return this;
    }

    public CommitCommand setAuthor(String name, String email) {
        this.checkCallable();
        return this.setAuthor(new PersonIdent(name, email));
    }

    public PersonIdent getAuthor() {
        return this.author;
    }

    public CommitCommand setAll(boolean all) {
        this.checkCallable();
        if (all && !this.only.isEmpty()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--all", "--only"));
        }
        this.all = all;
        return this;
    }

    public CommitCommand setAmend(boolean amend) {
        this.checkCallable();
        this.amend = amend;
        return this;
    }

    public CommitCommand setOnly(String only) {
        String o;
        this.checkCallable();
        if (this.all) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--only", "--all"));
        }
        String string = o = only.endsWith("/") ? only.substring(0, only.length() - 1) : only;
        if (!this.only.contains(o)) {
            this.only.add(o);
        }
        return this;
    }

    public CommitCommand setInsertChangeId(boolean insertChangeId) {
        this.checkCallable();
        this.insertChangeId = insertChangeId;
        return this;
    }

    public CommitCommand setReflogComment(String reflogComment) {
        this.reflogComment = reflogComment;
        this.useDefaultReflogMessage = false;
        return this;
    }

    public CommitCommand setNoVerify(boolean noVerify) {
        this.noVerify = noVerify;
        return this;
    }

    public CommitCommand setHookOutputStream(PrintStream hookStdOut) {
        this.setHookOutputStream("pre-commit", hookStdOut);
        this.setHookOutputStream("commit-msg", hookStdOut);
        this.setHookOutputStream("post-commit", hookStdOut);
        return this;
    }

    public CommitCommand setHookErrorStream(PrintStream hookStdErr) {
        this.setHookErrorStream("pre-commit", hookStdErr);
        this.setHookErrorStream("commit-msg", hookStdErr);
        this.setHookErrorStream("post-commit", hookStdErr);
        return this;
    }

    public CommitCommand setHookOutputStream(String hookName, PrintStream hookStdOut) {
        if (!("pre-commit".equals(hookName) || "commit-msg".equals(hookName) || "post-commit".equals(hookName))) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalHookName, hookName));
        }
        this.hookOutRedirect.put(hookName, hookStdOut);
        return this;
    }

    public CommitCommand setHookErrorStream(String hookName, PrintStream hookStdErr) {
        if (!("pre-commit".equals(hookName) || "commit-msg".equals(hookName) || "post-commit".equals(hookName))) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalHookName, hookName));
        }
        this.hookErrRedirect.put(hookName, hookStdErr);
        return this;
    }

    public CommitCommand setSigningKey(String signingKey) {
        this.checkCallable();
        this.signingKey = signingKey;
        return this;
    }

    public CommitCommand setSign(Boolean sign) {
        this.checkCallable();
        this.signCommit = sign;
        return this;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result() {
        if ($SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result != null) {
            return $SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result;
        }
        int[] nArray = new int[RefUpdate.Result.values().length];
        try {
            nArray[RefUpdate.Result.FAST_FORWARD.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.FORCED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.IO_FAILURE.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.LOCK_FAILURE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.NEW.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.NOT_ATTEMPTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.NO_CHANGE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.REJECTED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.REJECTED_CURRENT_BRANCH.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.REJECTED_MISSING_OBJECT.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.REJECTED_OTHER_REASON.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.RENAMED.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result = nArray;
        return nArray;
    }
}

