/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain;

import java.util.regex.Pattern;
import pl.allegro.tech.build.axion.release.domain.ScmState;
import pl.allegro.tech.build.axion.release.domain.VersionContext;
import pl.allegro.tech.build.axion.release.domain.VersionFactory;
import pl.allegro.tech.build.axion.release.domain.VersionSorter;
import pl.allegro.tech.build.axion.release.domain.properties.NextVersionProperties;
import pl.allegro.tech.build.axion.release.domain.properties.TagProperties;
import pl.allegro.tech.build.axion.release.domain.properties.VersionProperties;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPosition;
import pl.allegro.tech.build.axion.release.domain.scm.ScmRepository;
import pl.allegro.tech.build.axion.release.domain.scm.TaggedCommits;
import shadow.com.github.zafarkhaja.semver.Version;

public class VersionResolver {
    private final ScmRepository repository;
    private final VersionSorter sorter;
    private final String projectRootRelativePath;

    public VersionResolver(ScmRepository repository, String projectRootRelativePath) {
        this.repository = repository;
        this.projectRootRelativePath = projectRootRelativePath;
        this.sorter = new VersionSorter();
    }

    public VersionContext resolveVersion(VersionProperties versionProperties, TagProperties tagProperties, NextVersionProperties nextVersionProperties) {
        ScmPosition latestChangePosition = this.repository.positionOfLastChangeIn(this.projectRootRelativePath, versionProperties.getMonorepoProperties().getDirsToExclude());
        VersionFactory versionFactory = new VersionFactory(versionProperties, tagProperties, nextVersionProperties, latestChangePosition);
        VersionInfo versions = versionProperties.isUseHighestVersion() ? this.readVersionsByHighestVersion(versionFactory, tagProperties, nextVersionProperties, versionProperties, latestChangePosition) : this.readVersions(versionFactory, tagProperties, nextVersionProperties, versionProperties, latestChangePosition);
        ScmState scmState = new ScmState(versions.onReleaseTag, versions.onNextVersionTag, versions.noTagsFound, this.repository.checkUncommittedChanges());
        VersionFactory.FinalVersion finalVersion = versionFactory.createFinalVersion(scmState, versions.current);
        return new VersionContext(finalVersion.version, finalVersion.snapshot, versions.previous, latestChangePosition);
    }

    private VersionInfo readVersions(VersionFactory versionFactory, TagProperties tagProperties, NextVersionProperties nextVersionProperties, VersionProperties versionProperties, ScmPosition latestChangePosition) {
        String releaseTagPatternString = tagProperties.getPrefix();
        if (!releaseTagPatternString.isEmpty()) {
            releaseTagPatternString = releaseTagPatternString + tagProperties.getVersionSeparator();
        }
        Pattern releaseTagPattern = Pattern.compile("^" + releaseTagPatternString + ".*");
        Pattern nextVersionTagPattern = Pattern.compile(".*" + nextVersionProperties.getSuffix() + "$");
        boolean forceSnapshot = versionProperties.isForceSnapshot();
        TaggedCommits latestTaggedCommit = TaggedCommits.fromLatestCommit(this.repository, releaseTagPattern, latestChangePosition);
        VersionSorter.Result currentVersionInfo = this.versionFromTaggedCommits(latestTaggedCommit, false, nextVersionTagPattern, versionFactory, forceSnapshot);
        boolean onCommitWithLatestChange = currentVersionInfo.isSameCommit(latestChangePosition.getRevision());
        TaggedCommits previousTaggedCommit = TaggedCommits.fromLatestCommitBeforeNextVersion(this.repository, releaseTagPattern, nextVersionTagPattern, latestChangePosition);
        VersionSorter.Result previousVersionInfo = this.versionFromTaggedCommits(previousTaggedCommit, true, nextVersionTagPattern, versionFactory, forceSnapshot);
        Version currentVersion = currentVersionInfo.version;
        Version previousVersion = previousVersionInfo.version;
        return new VersionInfo(currentVersion, previousVersion, onCommitWithLatestChange && !currentVersionInfo.isNextVersion, currentVersionInfo.isNextVersion, currentVersionInfo.noTagsFound);
    }

    private VersionInfo readVersionsByHighestVersion(VersionFactory versionFactory, TagProperties tagProperties, NextVersionProperties nextVersionProperties, VersionProperties versionProperties, ScmPosition latestChangePosition) {
        Pattern releaseTagPattern = Pattern.compile("^" + tagProperties.getPrefix() + ".*");
        Pattern nextVersionTagPattern = Pattern.compile(".*" + nextVersionProperties.getSuffix() + "$");
        boolean forceSnapshot = versionProperties.isForceSnapshot();
        TaggedCommits allTaggedCommits = TaggedCommits.fromAllCommits(this.repository, releaseTagPattern, latestChangePosition);
        VersionSorter.Result currentVersionInfo = this.versionFromTaggedCommits(allTaggedCommits, false, nextVersionTagPattern, versionFactory, forceSnapshot);
        VersionSorter.Result previousVersionInfo = this.versionFromTaggedCommits(allTaggedCommits, true, nextVersionTagPattern, versionFactory, forceSnapshot);
        Version currentVersion = currentVersionInfo.version;
        Version previousVersion = previousVersionInfo.version;
        boolean onCommitWithLatestChange = currentVersionInfo.isSameCommit(latestChangePosition.getRevision());
        return new VersionInfo(currentVersion, previousVersion, onCommitWithLatestChange && !currentVersionInfo.isNextVersion, currentVersionInfo.isNextVersion, currentVersionInfo.noTagsFound);
    }

    private VersionSorter.Result versionFromTaggedCommits(TaggedCommits taggedCommits, boolean ignoreNextVersionTags, Pattern nextVersionTagPattern, VersionFactory versionFactory, boolean forceSnapshot) {
        return this.sorter.pickTaggedCommit(taggedCommits, ignoreNextVersionTags, forceSnapshot, nextVersionTagPattern, versionFactory);
    }

    private static final class VersionInfo {
        final Version current;
        final Version previous;
        final boolean onReleaseTag;
        final boolean onNextVersionTag;
        final boolean noTagsFound;

        VersionInfo(Version current, Version previous, boolean onReleaseTag, boolean onNextVersionTag, boolean noTagsFound) {
            this.current = current;
            this.previous = previous;
            this.onReleaseTag = onReleaseTag;
            this.onNextVersionTag = onNextVersionTag;
            this.noTagsFound = noTagsFound;
        }
    }
}

