/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.internal.storage.reftree;

import java.io.IOException;
import shadow.org.eclipse.jgit.annotations.Nullable;
import shadow.org.eclipse.jgit.dircache.DirCacheEntry;
import shadow.org.eclipse.jgit.errors.MissingObjectException;
import shadow.org.eclipse.jgit.internal.JGitText;
import shadow.org.eclipse.jgit.lib.Constants;
import shadow.org.eclipse.jgit.lib.ObjectId;
import shadow.org.eclipse.jgit.lib.ObjectIdRef;
import shadow.org.eclipse.jgit.lib.ObjectInserter;
import shadow.org.eclipse.jgit.lib.Ref;
import shadow.org.eclipse.jgit.lib.SymbolicRef;
import shadow.org.eclipse.jgit.revwalk.RevObject;
import shadow.org.eclipse.jgit.revwalk.RevTag;
import shadow.org.eclipse.jgit.revwalk.RevWalk;
import shadow.org.eclipse.jgit.transport.ReceiveCommand;

public class Command {
    private final Ref oldRef;
    private final Ref newRef;
    private final ReceiveCommand cmd;
    private ReceiveCommand.Result result;

    public static void abort(Iterable<Command> commands, @Nullable String why) {
        if (why == null || why.isEmpty()) {
            why = JGitText.get().transactionAborted;
        }
        for (Command c : commands) {
            if (c.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            c.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, why);
            why = JGitText.get().transactionAborted;
        }
    }

    public Command(@Nullable Ref oldRef, @Nullable Ref newRef) {
        this.oldRef = oldRef;
        this.newRef = newRef;
        this.cmd = null;
        this.result = ReceiveCommand.Result.NOT_ATTEMPTED;
        if (oldRef == null && newRef == null) {
            throw new IllegalArgumentException();
        }
        if (newRef != null && !newRef.isPeeled() && !newRef.isSymbolic()) {
            throw new IllegalArgumentException();
        }
        if (oldRef != null && newRef != null && !oldRef.getName().equals(newRef.getName())) {
            throw new IllegalArgumentException();
        }
    }

    public Command(RevWalk rw, ReceiveCommand cmd) throws MissingObjectException, IOException {
        this.oldRef = Command.toRef(rw, cmd.getOldId(), cmd.getOldSymref(), cmd.getRefName(), false);
        this.newRef = Command.toRef(rw, cmd.getNewId(), cmd.getNewSymref(), cmd.getRefName(), true);
        this.cmd = cmd;
    }

    static Ref toRef(RevWalk rw, ObjectId id, @Nullable String target, String name, boolean mustExist) throws MissingObjectException, IOException {
        if (target != null) {
            return new SymbolicRef(name, new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, target, id));
        }
        if (ObjectId.zeroId().equals(id)) {
            return null;
        }
        try {
            RevObject o = rw.parseAny(id);
            if (o instanceof RevTag) {
                RevObject p = rw.peel(o);
                return new ObjectIdRef.PeeledTag(Ref.Storage.NETWORK, name, id, p.copy());
            }
            return new ObjectIdRef.PeeledNonTag(Ref.Storage.NETWORK, name, id);
        }
        catch (MissingObjectException e) {
            if (mustExist) {
                throw e;
            }
            return new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, name, id);
        }
    }

    public String getRefName() {
        if (this.cmd != null) {
            return this.cmd.getRefName();
        }
        if (this.newRef != null) {
            return this.newRef.getName();
        }
        return this.oldRef.getName();
    }

    public void setResult(ReceiveCommand.Result result) {
        this.setResult(result, null);
    }

    public void setResult(ReceiveCommand.Result result, @Nullable String why) {
        if (this.cmd != null) {
            this.cmd.setResult(result, why);
        } else {
            this.result = result;
        }
    }

    public ReceiveCommand.Result getResult() {
        return this.cmd != null ? this.cmd.getResult() : this.result;
    }

    @Nullable
    public String getMessage() {
        return this.cmd != null ? this.cmd.getMessage() : null;
    }

    @Nullable
    public Ref getOldRef() {
        return this.oldRef;
    }

    @Nullable
    public Ref getNewRef() {
        return this.newRef;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        Command.append(s, this.oldRef, "CREATE");
        s.append(' ');
        Command.append(s, this.newRef, "DELETE");
        s.append(' ').append(this.getRefName());
        s.append(' ').append((Object)this.getResult());
        if (this.getMessage() != null) {
            s.append(' ').append(this.getMessage());
        }
        return s.toString();
    }

    private static void append(StringBuilder s, Ref r, String nullName) {
        if (r == null) {
            s.append(nullName);
        } else if (r.isSymbolic()) {
            s.append(r.getTarget().getName());
        } else {
            ObjectId id = r.getObjectId();
            if (id != null) {
                s.append(id.name());
            }
        }
    }

    boolean checkRef(@Nullable DirCacheEntry entry) {
        if (entry != null && entry.getRawMode() == 0) {
            entry = null;
        }
        return Command.check(entry, this.oldRef) || Command.check(entry, this.newRef);
    }

    private static boolean check(@Nullable DirCacheEntry cur, @Nullable Ref exp) {
        if (cur == null) {
            return exp == null;
        }
        if (exp == null) {
            return false;
        }
        if (exp.isSymbolic()) {
            String dst = exp.getTarget().getName();
            return cur.getRawMode() == 40960 && cur.getObjectId().equals(Command.symref(dst));
        }
        return cur.getRawMode() == 57344 && cur.getObjectId().equals(exp.getObjectId());
    }

    static ObjectId symref(String s) {
        ObjectInserter.Formatter fmt = new ObjectInserter.Formatter();
        return fmt.idFor(3, Constants.encode(s));
    }
}

