/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import shadow.org.eclipse.jgit.api.GitCommand;
import shadow.org.eclipse.jgit.api.errors.GitAPIException;
import shadow.org.eclipse.jgit.api.errors.JGitInternalException;
import shadow.org.eclipse.jgit.lib.Repository;
import shadow.org.eclipse.jgit.lib.StoredConfig;
import shadow.org.eclipse.jgit.transport.RemoteConfig;

public class RemoteRemoveCommand
extends GitCommand<RemoteConfig> {
    private String remoteName;

    protected RemoteRemoveCommand(Repository repo) {
        super(repo);
    }

    @Deprecated
    public void setName(String name) {
        this.remoteName = name;
    }

    public RemoteRemoveCommand setRemoteName(String remoteName) {
        this.remoteName = remoteName;
        return this;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.remoteName);
            config.unsetSection("remote", this.remoteName);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

