/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.jcraft.jsch.agentproxy.connector;

import java.io.IOException;
import shadow.com.jcraft.jsch.agentproxy.AgentProxyException;
import shadow.com.jcraft.jsch.agentproxy.Buffer;
import shadow.com.jcraft.jsch.agentproxy.Connector;
import shadow.com.jcraft.jsch.agentproxy.USocketFactory;

public class SSHAgentConnector
implements Connector {
    private USocketFactory factory;
    private String usocketPath;

    public SSHAgentConnector(USocketFactory factory) throws AgentProxyException {
        this(factory, null);
    }

    public SSHAgentConnector(USocketFactory factory, String usocketPath) throws AgentProxyException {
        this.factory = factory;
        this.usocketPath = usocketPath;
        USocketFactory.Socket sock = null;
        try {
            sock = this.open();
        }
        catch (IOException e) {
            throw new AgentProxyException(e.toString());
        }
        catch (Exception e) {
            throw new AgentProxyException(e.toString());
        }
        finally {
            try {
                if (sock != null) {
                    sock.close();
                }
            }
            catch (IOException e) {
                throw new AgentProxyException(e.toString());
            }
        }
    }

    public String getName() {
        return "ssh-agent";
    }

    public static boolean isConnectorAvailable() {
        return SSHAgentConnector.isConnectorAvailable(null);
    }

    public static boolean isConnectorAvailable(String usocketPath) {
        return System.getenv("SSH_AUTH_SOCK") != null || usocketPath != null;
    }

    public boolean isAvailable() {
        return SSHAgentConnector.isConnectorAvailable();
    }

    private USocketFactory.Socket open() throws IOException {
        String ssh_auth_sock = this.usocketPath;
        if (ssh_auth_sock == null) {
            ssh_auth_sock = System.getenv("SSH_AUTH_SOCK");
        }
        if (ssh_auth_sock == null) {
            throw new IOException("SSH_AUTH_SOCK is not defined.");
        }
        return this.factory.open(ssh_auth_sock);
    }

    public void query(Buffer buffer) throws AgentProxyException {
        USocketFactory.Socket sock = null;
        try {
            sock = this.open();
            sock.write(buffer.buffer, 0, buffer.getLength());
            buffer.rewind();
            int i = sock.readFull(buffer.buffer, 0, 4);
            i = buffer.getInt();
            buffer.rewind();
            buffer.checkFreeSize(i);
            i = sock.readFull(buffer.buffer, 0, i);
        }
        catch (IOException e) {
            throw new AgentProxyException(e.toString());
        }
        finally {
            try {
                if (sock != null) {
                    sock.close();
                }
            }
            catch (IOException e) {
                throw new AgentProxyException(e.toString());
            }
        }
    }
}

