/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain.scm;

import java.util.List;
import java.util.Optional;
import pl.allegro.tech.build.axion.release.domain.LocalOnlyResolver;
import pl.allegro.tech.build.axion.release.domain.logging.ReleaseLogger;
import pl.allegro.tech.build.axion.release.domain.scm.ScmException;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPosition;
import pl.allegro.tech.build.axion.release.domain.scm.ScmProperties;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPushResult;
import pl.allegro.tech.build.axion.release.domain.scm.ScmRepository;

public class ScmService {
    private static final ReleaseLogger logger = ReleaseLogger.Factory.logger(ScmService.class);
    private final LocalOnlyResolver localOnlyResolver;
    private final ScmProperties scmProperties;
    private ScmRepository repository;

    public ScmService(LocalOnlyResolver localOnlyResolver, ScmProperties scmProperties, ScmRepository repository) {
        this.localOnlyResolver = localOnlyResolver;
        this.scmProperties = scmProperties;
        this.repository = repository;
    }

    public void tag(String tagName) {
        this.repository.tag(tagName);
    }

    public void dropTag(String tagName) {
        try {
            this.repository.dropTag(tagName);
        }
        catch (ScmException e) {
            logger.quiet("Exception occurred during removing the tag: " + e.getMessage());
            throw e;
        }
    }

    public ScmPushResult push() {
        if (this.localOnlyResolver.localOnly(this.remoteAttached())) {
            logger.quiet("Changes made to local repository only");
            return new ScmPushResult(true, Optional.empty());
        }
        try {
            logger.quiet("Pushing all to remote: " + this.scmProperties.getRemote());
            return this.repository.push(this.scmProperties.getIdentity(), this.scmProperties.pushOptions());
        }
        catch (ScmException e) {
            logger.quiet("Exception occurred during push: " + e.getMessage());
            throw e;
        }
    }

    public ScmPosition position() {
        return this.repository.currentPosition();
    }

    public void commit(List patterns, String message) {
        this.repository.commit(patterns, message);
    }

    public boolean remoteAttached() {
        return this.repository.remoteAttached(this.scmProperties.getRemote());
    }

    public List<String> lastLogMessages(int messageCount) {
        return this.repository.lastLogMessages(messageCount);
    }
}

