/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain.hooks;

import groovy.lang.Closure;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import pl.allegro.tech.build.axion.release.domain.hooks.DefaultReleaseHookFactory;
import pl.allegro.tech.build.axion.release.domain.hooks.HookContext;
import pl.allegro.tech.build.axion.release.domain.hooks.ReleaseHookAction;
import pl.allegro.tech.build.axion.release.util.FileLoader;

public class FileUpdateHookAction
implements ReleaseHookAction {
    private final Map<String, Object> arguments;

    public FileUpdateHookAction(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    @Override
    public void act(HookContext hookContext) {
        this.arguments.computeIfAbsent("files", k -> Arrays.asList(this.arguments.get("file")));
        ((List)this.arguments.get("files")).forEach(f -> this.updateInFile(hookContext, f));
    }

    private void updateInFile(HookContext hookContext, Object potentialFile) {
        File file = FileLoader.asFile(potentialFile);
        String text = FileLoader.readFrom(potentialFile);
        String pattern = ((Closure)this.arguments.get("pattern")).call(new Object[]{hookContext.getPreviousVersion(), hookContext}).toString();
        String replacement = ((Closure)this.arguments.get("replacement")).call(new Object[]{hookContext.getReleaseVersion(), hookContext}).toString();
        try {
            hookContext.getLogger().quiet("Replacing pattern \"" + pattern + "\" with \"" + replacement + "\" in " + file.getCanonicalPath());
            String replacedText = Pattern.compile(pattern, 8).matcher(text).replaceAll(replacement);
            this.write(file, replacedText);
            hookContext.addCommitPattern(file.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(File file, String text) {
        try (FileWriter fw = new FileWriter(file);){
            BufferedWriter writer = new BufferedWriter(fw);
            writer.write(text);
            writer.flush();
        }
        catch (IOException e) {
            throw new FileUpdateHookException(e);
        }
    }

    public static final class Factory
    extends DefaultReleaseHookFactory {
        @Override
        public ReleaseHookAction create(Map<String, Object> arguments) {
            return new FileUpdateHookAction(arguments);
        }
    }

    private static final class FileUpdateHookException
    extends RuntimeException {
        FileUpdateHookException(Exception e) {
            super(e);
        }
    }
}

