/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.googlecode.javaewah;

import shadow.com.googlecode.javaewah.BitmapStorage;
import shadow.com.googlecode.javaewah.Buffer;

public final class BitCounter
implements BitmapStorage {
    private int oneBits;

    @Override
    public void addWord(long newData) {
        this.oneBits += Long.bitCount(newData);
    }

    @Override
    public void addLiteralWord(long newData) {
        this.oneBits += Long.bitCount(newData);
    }

    @Override
    public void addStreamOfLiteralWords(Buffer buffer, int start, int number) {
        for (int i = start; i < start + number; ++i) {
            this.addLiteralWord(buffer.getWord(i));
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, long number) {
        if (v) {
            this.oneBits += (int)(number * 64L);
        }
    }

    @Override
    public void addStreamOfNegatedLiteralWords(Buffer buffer, int start, int number) {
        for (int i = start; i < start + number; ++i) {
            this.addLiteralWord(buffer.getWord(i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public void clear() {
        this.oneBits = 0;
    }

    public int getCount() {
        return this.oneBits;
    }

    @Override
    public void setSizeInBitsWithinLastWord(int bits) {
    }
}

