/*
 * Decompiled with CFR 0.152.
 */
package oxim.digital.rxanim;

import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import java.util.concurrent.TimeUnit;
import oxim.digital.rxanim.RxAnimationBuilder;
import oxim.digital.rxanim.RxAnimations$$Lambda$1;
import oxim.digital.rxanim.RxAnimations$$Lambda$10;
import oxim.digital.rxanim.RxAnimations$$Lambda$11;
import oxim.digital.rxanim.RxAnimations$$Lambda$12;
import oxim.digital.rxanim.RxAnimations$$Lambda$13;
import oxim.digital.rxanim.RxAnimations$$Lambda$14;
import oxim.digital.rxanim.RxAnimations$$Lambda$15;
import oxim.digital.rxanim.RxAnimations$$Lambda$16;
import oxim.digital.rxanim.RxAnimations$$Lambda$17;
import oxim.digital.rxanim.RxAnimations$$Lambda$18;
import oxim.digital.rxanim.RxAnimations$$Lambda$19;
import oxim.digital.rxanim.RxAnimations$$Lambda$2;
import oxim.digital.rxanim.RxAnimations$$Lambda$20;
import oxim.digital.rxanim.RxAnimations$$Lambda$3;
import oxim.digital.rxanim.RxAnimations$$Lambda$4;
import oxim.digital.rxanim.RxAnimations$$Lambda$5;
import oxim.digital.rxanim.RxAnimations$$Lambda$6;
import oxim.digital.rxanim.RxAnimations$$Lambda$7;
import oxim.digital.rxanim.RxAnimations$$Lambda$8;
import oxim.digital.rxanim.RxAnimations$$Lambda$9;
import rx.Completable;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action0;
import rx.functions.Action1;

public final class RxAnimations {
    private static final float OPAQUE = 1.0f;
    private static final float TRANSPARENT = 0.0f;
    private static final int IMMEDIATE = 0;

    public static Completable animateTogether(Completable ... completables) {
        return Completable.merge((Completable[])completables);
    }

    public static Completable hide(View view) {
        return RxAnimationBuilder.animate(view, 0).fadeOut().schedule();
    }

    public static Completable hide(View ... views) {
        return Observable.from((Object[])views).flatMap(RxAnimations$$Lambda$1.lambdaFactory$()).toCompletable();
    }

    public static Completable hideViewGroupChildren(ViewGroup viewGroup) {
        return Completable.fromAction((Action0)RxAnimations$$Lambda$2.lambdaFactory$(viewGroup));
    }

    public static Completable hideViewGroupChildren(ViewGroup ... viewGroups) {
        return Observable.from((Object[])viewGroups).flatMap(RxAnimations$$Lambda$3.lambdaFactory$()).toCompletable();
    }

    private static void hideViewGroup(ViewGroup viewGroup) {
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = viewGroup.getChildAt(i);
            if (child instanceof ViewGroup) {
                RxAnimations.hideViewGroup((ViewGroup)child);
                continue;
            }
            child.setAlpha(0.0f);
        }
    }

    public static Completable show(View view) {
        return RxAnimationBuilder.animate(view, 0).fadeIn().schedule();
    }

    public static Completable fadeIn(View view) {
        return RxAnimationBuilder.animate(view).fadeIn().onAnimationCancel((Action1<View>)RxAnimations$$Lambda$4.lambdaFactory$()).schedule();
    }

    public static Completable fadeIn(View view, int duration) {
        return RxAnimationBuilder.animate(view, (Interpolator)new DecelerateInterpolator()).duration(duration).fadeIn().onAnimationCancel((Action1<View>)RxAnimations$$Lambda$5.lambdaFactory$()).schedule();
    }

    public static Completable fadeIn(View view, int duration, int delay) {
        return RxAnimationBuilder.animate(view, duration, delay).interpolator((Interpolator)new DecelerateInterpolator()).fadeIn().onAnimationCancel((Action1<View>)RxAnimations$$Lambda$6.lambdaFactory$()).schedule();
    }

    public static Completable fadeInWithDelay(int delay, int duration, View ... views) {
        return Observable.range((int)0, (int)views.length).flatMap(RxAnimations$$Lambda$7.lambdaFactory$(views, duration, delay)).toCompletable();
    }

    public static Completable slideHorizontal(View view, int duration, int xOffset) {
        float endingX = view.getX() + (float)xOffset;
        return RxAnimationBuilder.animate(view, (Interpolator)new AccelerateDecelerateInterpolator()).duration(duration).translateBy(xOffset, 0).onAnimationCancel((Action1<View>)RxAnimations$$Lambda$8.lambdaFactory$(endingX)).schedule(false);
    }

    public static Completable slideVertical(View view, int duration, int yOffset) {
        float endingY = view.getY() + (float)yOffset;
        return RxAnimationBuilder.animate(view, (Interpolator)new AccelerateDecelerateInterpolator()).duration(duration).translateBy(0, yOffset).onAnimationCancel((Action1<View>)RxAnimations$$Lambda$9.lambdaFactory$(endingY)).schedule(false);
    }

    public static Completable enter(View view, int xOffset, int yOffset) {
        float startingX = view.getX();
        float startingY = view.getY();
        return RxAnimationBuilder.animate(view, (Interpolator)new DecelerateInterpolator()).fadeIn().translateBy(xOffset, yOffset).onAnimationCancel((Action1<View>)RxAnimations$$Lambda$10.lambdaFactory$(startingX, startingY)).schedule();
    }

    public static Completable enter(View view, int delay, int xOffset, int yOffset) {
        float startingX = view.getX();
        float startingY = view.getY();
        return RxAnimationBuilder.animate(view, (Interpolator)new DecelerateInterpolator()).delay(delay).fadeIn().translateBy(xOffset, yOffset).onAnimationCancel((Action1<View>)RxAnimations$$Lambda$11.lambdaFactory$(startingX, startingY)).schedule();
    }

    public static Completable enter(View view, int duration, int xOffset, int yOffset, int delay) {
        float startingX = view.getX();
        float startingY = view.getY();
        return RxAnimationBuilder.animate(view, duration, delay).interpolator((Interpolator)new DecelerateInterpolator()).fadeIn().translateBy(xOffset, yOffset).onAnimationCancel((Action1<View>)RxAnimations$$Lambda$12.lambdaFactory$(startingX, startingY)).schedule();
    }

    public static Completable enterTogether(int delay, int xOffset, View ... views) {
        return RxAnimations.doAfterDelay(delay, Observable.from((Object[])views).flatMap(RxAnimations$$Lambda$13.lambdaFactory$(xOffset)).toCompletable());
    }

    public static Completable enterViewsWithDelay(int delay, int duration, int xOffset, View ... views) {
        return RxAnimations.enterViewsWithDelay(0, delay, duration, xOffset, views);
    }

    public static Completable enterViewsWithDelay(int initialDelay, int delay, int duration, int xOffset, View ... views) {
        return Observable.range((int)0, (int)views.length).flatMap(RxAnimations$$Lambda$14.lambdaFactory$(views, duration, xOffset, delay, initialDelay)).toCompletable();
    }

    public static Completable enterWithRotation(View view, int duration, int xOffset, int yOffset, int delay, int rotation) {
        float startingX = view.getX();
        float startingY = view.getY();
        float startRotation = view.getRotation();
        return RxAnimationBuilder.animate(view, duration, delay).fadeIn().counterRotateBy(rotation).translateBy(xOffset, yOffset).onAnimationCancel((Action1<View>)RxAnimations$$Lambda$15.lambdaFactory$(startingX, startingY, startRotation)).schedule();
    }

    public static Completable leave(View view, int xOffset, int yOffset) {
        float startingX = view.getX();
        float startingY = view.getY();
        return RxAnimationBuilder.animate(view, (Interpolator)new AccelerateInterpolator()).fadeOut().translateBy(xOffset, yOffset).onAnimationCancel((Action1<View>)RxAnimations$$Lambda$16.lambdaFactory$(startingX, startingY)).schedule(false);
    }

    public static Completable fadeOut(View view) {
        return RxAnimationBuilder.animate(view, (Interpolator)new AccelerateInterpolator()).fadeOut().onAnimationCancel((Action1<View>)RxAnimations$$Lambda$17.lambdaFactory$()).schedule();
    }

    public static Completable fadeOut(View view, int duration) {
        return RxAnimationBuilder.animate(view, (Interpolator)new AccelerateInterpolator()).duration(duration).fadeOut().onAnimationCancel((Action1<View>)RxAnimations$$Lambda$18.lambdaFactory$()).schedule();
    }

    public static Completable fadeOut(View view, int duration, int delay) {
        return RxAnimationBuilder.animate(view, duration, delay).interpolator((Interpolator)new AccelerateInterpolator()).fadeOut().onAnimationCancel((Action1<View>)RxAnimations$$Lambda$19.lambdaFactory$()).schedule();
    }

    public static Completable doAfterDelay(int delay, Action0 action) {
        return Completable.timer((long)delay, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).concatWith(Completable.fromAction((Action0)action));
    }

    public static Completable doAfterDelay(int delay, Completable completable) {
        return Completable.timer((long)delay, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).concatWith(completable);
    }

    public static void set(View view, float x, float y, float alpha) {
        view.setAlpha(alpha);
        view.setX(x);
        view.setY(y);
    }

    public static void set(View view, float x, float y, float alpha, float rotation) {
        RxAnimations.set(view, x, y, alpha);
        view.setRotation(rotation);
    }

    static /* synthetic */ void lambda$fadeOut$47(View aView) {
        aView.setAlpha(0.0f);
    }

    static /* synthetic */ void lambda$fadeOut$46(View aView) {
        aView.setAlpha(0.0f);
    }

    static /* synthetic */ void lambda$fadeOut$45(View aView) {
        aView.setAlpha(0.0f);
    }

    static /* synthetic */ void lambda$leave$44(float startingX, float startingY, View aView) {
        RxAnimations.set(aView, startingX, startingY, 0.0f);
    }

    static /* synthetic */ void lambda$enterWithRotation$43(float startingX, float startingY, float startRotation, View aView) {
        RxAnimations.set(aView, startingX, startingY, 1.0f, startRotation);
    }

    static /* synthetic */ Observable lambda$enterViewsWithDelay$42(View[] views, int duration, int xOffset, int delay, int initialDelay, Integer i) {
        return RxAnimations.enter(views[i], duration, xOffset, 0, i * delay + initialDelay).toObservable();
    }

    static /* synthetic */ Observable lambda$enterTogether$41(int xOffset, View view) {
        return RxAnimations.enter(view, xOffset, 0).toObservable();
    }

    static /* synthetic */ void lambda$enter$40(float startingX, float startingY, View aView) {
        RxAnimations.set(aView, startingX, startingY, 1.0f);
    }

    static /* synthetic */ void lambda$enter$39(float startingX, float startingY, View aView) {
        RxAnimations.set(aView, startingX, startingY, 1.0f);
    }

    static /* synthetic */ void lambda$enter$38(float startingX, float startingY, View aView) {
        RxAnimations.set(aView, startingX, startingY, 1.0f);
    }

    static /* synthetic */ void lambda$slideVertical$37(float endingY, View v) {
        v.setY(endingY);
    }

    static /* synthetic */ void lambda$slideHorizontal$36(float endingX, View v) {
        v.setX(endingX);
    }

    static /* synthetic */ Observable lambda$fadeInWithDelay$35(View[] views, int duration, int delay, Integer i) {
        return RxAnimationBuilder.animate(views[i], (Interpolator)new LinearInterpolator()).duration(duration).delay(i * delay).fadeIn().onAnimationCancel((Action1<View>)RxAnimations$$Lambda$20.lambdaFactory$()).schedule().toObservable();
    }

    static /* synthetic */ void lambda$null$34(View aView) {
        aView.setAlpha(1.0f);
    }

    static /* synthetic */ void lambda$fadeIn$33(View aView) {
        aView.setAlpha(1.0f);
    }

    static /* synthetic */ void lambda$fadeIn$32(View aView) {
        aView.setAlpha(1.0f);
    }

    static /* synthetic */ void lambda$fadeIn$31(View aView) {
        aView.setAlpha(1.0f);
    }

    static /* synthetic */ Observable lambda$hideViewGroupChildren$30(ViewGroup viewGroup) {
        return RxAnimations.hideViewGroupChildren(viewGroup).toObservable();
    }

    static /* synthetic */ void lambda$hideViewGroupChildren$29(ViewGroup viewGroup) {
        RxAnimations.hideViewGroup(viewGroup);
    }

    static /* synthetic */ Observable lambda$hide$28(View view) {
        return RxAnimations.hide(view).toObservable();
    }
}

