/*
 * Decompiled with CFR 0.152.
 */
package oxim.digital.rxanim;

import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import java.util.concurrent.TimeUnit;
import oxim.digital.rxanim.RxAnimationBuilder;
import oxim.digital.rxanim.RxAnimations$$Lambda$1;
import oxim.digital.rxanim.RxAnimations$$Lambda$2;
import oxim.digital.rxanim.RxAnimations$$Lambda$3;
import oxim.digital.rxanim.RxAnimations$$Lambda$4;
import oxim.digital.rxanim.RxAnimations$$Lambda$5;
import oxim.digital.rxanim.RxAnimations$$Lambda$6;
import rx.Completable;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action0;

public final class RxAnimations {
    private static final int IMMEDIATE = 0;

    public static Completable animateTogether(Completable ... completables) {
        return Completable.merge((Completable[])completables);
    }

    public static Completable hide(View view) {
        return RxAnimationBuilder.animate(view, 0).fadeOut().schedule();
    }

    public static Completable hide(View ... views) {
        return Observable.from((Object[])views).flatMap(RxAnimations$$Lambda$1.lambdaFactory$()).toCompletable();
    }

    public static Completable hideViewGroupChildren(ViewGroup viewGroup) {
        return Completable.fromAction((Action0)RxAnimations$$Lambda$2.lambdaFactory$(viewGroup));
    }

    public static Completable hideViewGroupChildren(ViewGroup ... viewGroups) {
        return Observable.from((Object[])viewGroups).flatMap(RxAnimations$$Lambda$3.lambdaFactory$()).toCompletable();
    }

    private static void hideViewGroup(ViewGroup viewGroup) {
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = viewGroup.getChildAt(i);
            if (child instanceof ViewGroup) {
                RxAnimations.hideViewGroup((ViewGroup)child);
                continue;
            }
            child.setAlpha(0.0f);
        }
    }

    public static Completable show(View view) {
        return RxAnimationBuilder.animate(view, 0).fadeIn().schedule();
    }

    public static Completable fadeIn(View view) {
        return RxAnimationBuilder.animate(view).fadeIn().schedule();
    }

    public static Completable fadeIn(View view, int duration) {
        return RxAnimationBuilder.animate(view, (Interpolator)new DecelerateInterpolator()).duration(duration).fadeIn().schedule();
    }

    public static Completable fadeIn(View view, int duration, int delay) {
        return RxAnimationBuilder.animate(view, duration, delay).interpolator((Interpolator)new DecelerateInterpolator()).fadeIn().schedule();
    }

    public static Completable fadeInWithDelay(int delay, int duration, View ... views) {
        return Observable.range((int)0, (int)views.length).flatMap(RxAnimations$$Lambda$4.lambdaFactory$(views, duration, delay)).toCompletable();
    }

    public static Completable slideIn(View view, int duration, int xOffset) {
        return RxAnimationBuilder.animate(view, (Interpolator)new DecelerateInterpolator()).duration(duration).translateBy(xOffset, 0).schedule();
    }

    public static Completable enter(View view, int xOffset, int yOffset) {
        return RxAnimationBuilder.animate(view, (Interpolator)new DecelerateInterpolator()).fadeIn().translateBy(xOffset, yOffset).schedule();
    }

    public static Completable enter(View view, int delay, int xOffset, int yOffset) {
        return RxAnimationBuilder.animate(view, (Interpolator)new DecelerateInterpolator()).delay(delay).fadeIn().translateBy(xOffset, yOffset).schedule();
    }

    public static Completable enter(View view, int duration, int xOffset, int yOffset, int delay) {
        return RxAnimationBuilder.animate(view, duration, delay).interpolator((Interpolator)new DecelerateInterpolator()).fadeIn().translateBy(xOffset, yOffset).schedule();
    }

    public static Completable enterTogether(int delay, int xOffset, View ... views) {
        return Observable.from((Object[])views).flatMap(RxAnimations$$Lambda$5.lambdaFactory$(delay, xOffset)).toCompletable();
    }

    public static Completable enterViewsWithDelay(int delay, int duration, int xOffset, View ... views) {
        return RxAnimations.enterViewsWithDelay(0, delay, duration, xOffset, views);
    }

    public static Completable enterViewsWithDelay(int initialDelay, int delay, int duration, int xOffset, View ... views) {
        return Observable.range((int)0, (int)views.length).flatMap(RxAnimations$$Lambda$6.lambdaFactory$(views, duration, xOffset, delay, initialDelay)).toCompletable();
    }

    public static Completable enterWithRotation(View view, int duration, int xOffset, int yOffset, int delay, int rotation) {
        return RxAnimationBuilder.animate(view, duration, delay).fadeIn().counterRotateBy(rotation).translateBy(xOffset, yOffset).schedule();
    }

    public static Completable leave(View view, int xOffset, int yOffset) {
        return RxAnimationBuilder.animate(view, (Interpolator)new AccelerateInterpolator()).fadeOut().translateBy(-xOffset, -yOffset).schedule();
    }

    public static Completable doAfterDelay(int delay, Action0 action) {
        return Completable.timer((long)delay, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).concatWith(Completable.fromAction((Action0)action));
    }

    static /* synthetic */ Observable lambda$enterViewsWithDelay$30(View[] views, int duration, int xOffset, int delay, int initialDelay, Integer i) {
        return RxAnimations.enter(views[i], duration, xOffset, 0, i * delay + initialDelay).toObservable();
    }

    static /* synthetic */ Observable lambda$enterTogether$29(int delay, int xOffset, View view) {
        return RxAnimationBuilder.animate(view, (Interpolator)new DecelerateInterpolator()).delay(delay).fadeIn().translateBy(xOffset, 0).schedule().toObservable();
    }

    static /* synthetic */ Observable lambda$fadeInWithDelay$28(View[] views, int duration, int delay, Integer i) {
        return RxAnimationBuilder.animate(views[i], (Interpolator)new LinearInterpolator()).duration(duration).delay(i * delay).fadeIn().schedule().toObservable();
    }

    static /* synthetic */ Observable lambda$hideViewGroupChildren$27(ViewGroup viewGroup) {
        return RxAnimations.hideViewGroupChildren(viewGroup).toObservable();
    }

    static /* synthetic */ void lambda$hideViewGroupChildren$26(ViewGroup viewGroup) {
        RxAnimations.hideViewGroup(viewGroup);
    }

    static /* synthetic */ Observable lambda$hide$25(View view) {
        return RxAnimations.hide(view).toObservable();
    }
}

