/*
 * Decompiled with CFR 0.152.
 */
package oxim.digital.rxanim;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import oxim.digital.rxanim.RxObservableValueAnimator$$Lambda$1;
import rx.Observable;
import rx.subjects.BehaviorSubject;

public final class RxObservableValueAnimator {
    private final ValueAnimator valueAnimator;
    private BehaviorSubject<Object> valueUpdateSubject;

    public static RxObservableValueAnimator from(ValueAnimator valueAnimator) {
        return new RxObservableValueAnimator(valueAnimator);
    }

    private RxObservableValueAnimator(ValueAnimator valueAnimator) {
        this.valueAnimator = valueAnimator;
        this.valueUpdateSubject = BehaviorSubject.create();
        this.valueAnimator.addUpdateListener(RxObservableValueAnimator$$Lambda$1.lambdaFactory$(this));
        this.valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                RxObservableValueAnimator.this.valueUpdateSubject.onCompleted();
            }
        });
    }

    public Observable<Object> schedule() {
        this.checkSubject();
        this.valueAnimator.start();
        return this.valueUpdateSubject;
    }

    public Observable<Object> scheduleReversed() {
        this.checkSubject();
        this.valueAnimator.reverse();
        return this.valueUpdateSubject;
    }

    private void checkSubject() {
        if (this.valueUpdateSubject.hasCompleted() || this.valueUpdateSubject.hasThrowable()) {
            this.valueUpdateSubject = BehaviorSubject.create();
        }
    }

    public float getAnimatedFraction() {
        return this.valueAnimator.getAnimatedFraction();
    }

    public void end() {
        this.valueAnimator.end();
        this.valueUpdateSubject.onCompleted();
    }

    /* synthetic */ void lambda$new$31(ValueAnimator animation) {
        this.valueUpdateSubject.onNext(animation.getAnimatedValue());
    }
}

