/*
 * Decompiled with CFR 0.152.
 */
package oxim.digital.rx2anim;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import oxim.digital.rx2anim.RxValueObservable$$Lambda$1;
import oxim.digital.rx2anim.RxValueObservable$$Lambda$2;
import oxim.digital.rx2anim.RxValueObservable$$Lambda$3;
import oxim.digital.rx2anim.RxValueObservable$$Lambda$4;

public final class RxValueObservable
extends Observable<Object> {
    private final ValueAnimator valueAnimator;
    private final boolean isReversed;
    private final Function<ValueAnimator, Object> valueFactory;

    public static RxValueObservable from(ValueAnimator valueAnimator) {
        return new RxValueObservable(valueAnimator, false, (Function<ValueAnimator, Object>)RxValueObservable$$Lambda$1.lambdaFactory$());
    }

    public static RxValueObservable fromReversed(ValueAnimator valueAnimator) {
        return new RxValueObservable(valueAnimator, true, (Function<ValueAnimator, Object>)RxValueObservable$$Lambda$2.lambdaFactory$());
    }

    public static RxValueObservable fractionFrom(ValueAnimator valueAnimator) {
        return new RxValueObservable(valueAnimator, false, (Function<ValueAnimator, Object>)RxValueObservable$$Lambda$3.lambdaFactory$());
    }

    public static RxValueObservable fractionFromReversed(ValueAnimator valueAnimator) {
        return new RxValueObservable(valueAnimator, true, (Function<ValueAnimator, Object>)RxValueObservable$$Lambda$4.lambdaFactory$());
    }

    public static RxValueObservable from(ValueAnimator valueAnimator, boolean isReversed, Function<ValueAnimator, Object> valueFactory) {
        return new RxValueObservable(valueAnimator, isReversed, valueFactory);
    }

    private RxValueObservable(ValueAnimator valueAnimator, boolean isReversed, Function<ValueAnimator, Object> valueFactory) {
        this.valueAnimator = valueAnimator;
        this.isReversed = isReversed;
        this.valueFactory = valueFactory;
    }

    protected void subscribeActual(Observer<? super Object> observer) {
        MainThreadDisposable.verifyMainThread();
        UpdateListener updateListener = new UpdateListener(observer, this.valueFactory);
        EndListener endListener = new EndListener(observer, this.valueAnimator);
        UpdateDisposable updateDisposable = new UpdateDisposable(this.valueAnimator, updateListener, endListener);
        observer.onSubscribe((Disposable)updateDisposable);
        this.valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)updateListener);
        this.valueAnimator.addListener((Animator.AnimatorListener)endListener);
        this.startAnimator();
    }

    private void startAnimator() {
        if (this.isReversed) {
            this.valueAnimator.reverse();
        } else {
            this.valueAnimator.start();
        }
    }

    private static final class UpdateDisposable
    extends MainThreadDisposable {
        private final ValueAnimator valueAnimator;
        private final UpdateListener updateListener;
        private final EndListener endListener;

        public UpdateDisposable(ValueAnimator valueAnimator, UpdateListener updateListener, EndListener endListener) {
            this.valueAnimator = valueAnimator;
            this.updateListener = updateListener;
            this.endListener = endListener;
        }

        protected void onDispose() {
            this.valueAnimator.end();
            this.valueAnimator.removeUpdateListener((ValueAnimator.AnimatorUpdateListener)this.updateListener);
            this.valueAnimator.removeListener((Animator.AnimatorListener)this.endListener);
        }
    }

    private static final class EndListener
    extends AnimatorListenerAdapter {
        private final Observer<? super Object> observer;
        private final ValueAnimator valueAnimator;

        public EndListener(Observer<? super Object> observer, ValueAnimator valueAnimator) {
            this.observer = observer;
            this.valueAnimator = valueAnimator;
        }

        public void onAnimationEnd(Animator animation) {
            this.valueAnimator.removeListener((Animator.AnimatorListener)this);
            this.observer.onComplete();
        }
    }

    private static final class UpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private final Observer<? super Object> observer;
        private final Function<ValueAnimator, Object> valueFactory;

        public UpdateListener(Observer<? super Object> observer, Function<ValueAnimator, Object> valueFactory) {
            this.observer = observer;
            this.valueFactory = valueFactory;
        }

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            try {
                this.observer.onNext(this.valueFactory.apply((Object)valueAnimator));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

