/*
 * Decompiled with CFR 0.152.
 */
package oxim.digital.rx2anim;

import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.view.View;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.lang.ref.WeakReference;
import java.util.List;
import oxim.digital.rx2anim.AnimateCompletable$$Lambda$1;
import oxim.digital.rx2anim.AnimateCompletable$$Lambda$2;
import oxim.digital.rx2anim.AnimationDisposable;

public final class AnimateCompletable
extends Completable {
    private static final int NONE = 0;
    private final WeakReference<View> viewWeakRef;
    private final List<Consumer<ViewPropertyAnimatorCompat>> preTransformActions;
    private final List<Consumer<ViewPropertyAnimatorCompat>> animationActions;
    private final Consumer<View> onAnimationCancelAction;

    public static AnimateCompletable forView(WeakReference<View> viewWeakRef, @Nullable List<Consumer<ViewPropertyAnimatorCompat>> preTransformActions, List<Consumer<ViewPropertyAnimatorCompat>> animationActions, Consumer<View> onAnimationCancelAction) {
        return new AnimateCompletable(viewWeakRef, preTransformActions, animationActions, onAnimationCancelAction);
    }

    private AnimateCompletable(WeakReference<View> viewWeakRef, @Nullable List<Consumer<ViewPropertyAnimatorCompat>> preTransformActions, List<Consumer<ViewPropertyAnimatorCompat>> animationActions, Consumer<View> onAnimationCancelAction) {
        this.viewWeakRef = viewWeakRef;
        this.preTransformActions = preTransformActions;
        this.animationActions = animationActions;
        this.onAnimationCancelAction = onAnimationCancelAction;
    }

    protected void subscribeActual(CompletableObserver completableObserver) {
        MainThreadDisposable.verifyMainThread();
        View view = (View)this.viewWeakRef.get();
        if (view == null) {
            completableObserver.onComplete();
            return;
        }
        ViewPropertyAnimatorCompat animator = ViewCompat.animate((View)view);
        completableObserver.onSubscribe(this.createAnimationDisposable(animator, this.onAnimationCancelAction));
        if (this.preTransformActions != null) {
            this.applyActions(this.preTransformActions, animator);
            animator.setDuration(0L).setStartDelay(0L).withEndAction(AnimateCompletable$$Lambda$1.lambdaFactory$(this, completableObserver, animator)).start();
        } else {
            this.runAnimation(completableObserver, animator);
        }
    }

    private void applyActions(List<Consumer<ViewPropertyAnimatorCompat>> actions, ViewPropertyAnimatorCompat animator) {
        for (Consumer<ViewPropertyAnimatorCompat> action : actions) {
            try {
                action.accept((Object)animator);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void runAnimation(CompletableObserver completableObserver, ViewPropertyAnimatorCompat animator) {
        this.applyActions(this.animationActions, animator);
        CompletableObserver completableObserver2 = completableObserver;
        completableObserver2.getClass();
        animator.withEndAction(AnimateCompletable$$Lambda$2.lambdaFactory$(completableObserver2)).start();
    }

    private Disposable createAnimationDisposable(ViewPropertyAnimatorCompat animator, Consumer<View> animationCancelAction) {
        return new AnimationDisposable(animator, animationCancelAction);
    }

    /* synthetic */ void lambda$subscribeActual$0(CompletableObserver completableObserver, ViewPropertyAnimatorCompat animator) {
        this.runAnimation(completableObserver, animator);
    }
}

