/*
 * Decompiled with CFR 0.152.
 */
package oxim.digital.rx2anim;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import oxim.digital.rx2anim.RxValueAnimator$$Lambda$1;

public final class RxValueAnimator
extends Completable {
    private static final float FULLY_ANIMATED = 1.0f;
    private final ValueAnimator valueAnimator;
    private final Consumer<ValueAnimator> valueUpdateAction;
    private final Consumer<ValueAnimator> animationCancelAction;

    public static RxValueAnimator from(ValueAnimator valueAnimator, Consumer<ValueAnimator> valueUpdateAction) {
        return RxValueAnimator.from(valueAnimator, valueUpdateAction, (Consumer<ValueAnimator>)RxValueAnimator$$Lambda$1.lambdaFactory$());
    }

    public static RxValueAnimator from(ValueAnimator valueAnimator, Consumer<ValueAnimator> valueUpdateAction, Consumer<ValueAnimator> animationCancelAction) {
        return new RxValueAnimator(valueAnimator, valueUpdateAction, animationCancelAction);
    }

    private RxValueAnimator(ValueAnimator valueAnimator, Consumer<ValueAnimator> valueUpdateAction, Consumer<ValueAnimator> animationCancelAction) {
        this.valueAnimator = valueAnimator;
        this.valueUpdateAction = valueUpdateAction;
        this.animationCancelAction = animationCancelAction;
    }

    protected void subscribeActual(CompletableObserver completableObserver) {
        MainThreadDisposable.verifyMainThread();
        UpdateListener updateListener = new UpdateListener(completableObserver, this.valueUpdateAction);
        AnimationEndListener endListener = new AnimationEndListener(completableObserver, this.valueAnimator, this.animationCancelAction);
        ValueAnimatorDisposable animatorDisposable = new ValueAnimatorDisposable(this.valueAnimator, updateListener, endListener);
        completableObserver.onSubscribe((Disposable)animatorDisposable);
        this.valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)updateListener);
        this.valueAnimator.addListener((Animator.AnimatorListener)endListener);
        this.valueAnimator.start();
    }

    static /* synthetic */ void lambda$from$44(ValueAnimator aValueAnimator) throws Exception {
    }

    private static final class AnimationEndListener
    extends AnimatorListenerAdapter {
        private final CompletableObserver observer;
        private final ValueAnimator animator;
        private final Consumer<ValueAnimator> animationCancelAction;

        public AnimationEndListener(CompletableObserver observer, ValueAnimator animator, Consumer<ValueAnimator> animationCancelAction) {
            this.observer = observer;
            this.animator = animator;
            this.animationCancelAction = animationCancelAction;
        }

        public void onAnimationCancel(Animator animation) {
            try {
                this.animationCancelAction.accept((Object)this.animator);
                this.dispose();
            }
            catch (Exception e) {
                this.animator.removeListener((Animator.AnimatorListener)this);
                this.observer.onError((Throwable)e);
            }
        }

        public void onAnimationEnd(Animator animation) {
            this.dispose();
        }

        private void dispose() {
            this.animator.removeListener((Animator.AnimatorListener)this);
            this.observer.onComplete();
        }
    }

    private static final class UpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private final CompletableObserver observer;
        private final Consumer<ValueAnimator> valueUpdateAction;

        public UpdateListener(CompletableObserver observer, Consumer<ValueAnimator> valueUpdateAction) {
            this.observer = observer;
            this.valueUpdateAction = valueUpdateAction;
        }

        public void onAnimationUpdate(ValueAnimator animator) {
            try {
                this.valueUpdateAction.accept((Object)animator);
            }
            catch (Exception e) {
                this.observer.onError((Throwable)e);
            }
        }
    }

    private static final class ValueAnimatorDisposable
    extends MainThreadDisposable {
        private final ValueAnimator animator;
        private final UpdateListener updateListener;
        public final AnimationEndListener animationEndListener;

        public ValueAnimatorDisposable(ValueAnimator animator, UpdateListener updateListener, AnimationEndListener animationEndListener) {
            this.animator = animator;
            this.updateListener = updateListener;
            this.animationEndListener = animationEndListener;
        }

        protected void onDispose() {
            if (this.animator.getAnimatedFraction() != 1.0f) {
                this.animator.cancel();
            } else {
                this.animator.end();
            }
            this.animator.removeUpdateListener((ValueAnimator.AnimatorUpdateListener)this.updateListener);
            this.animator.removeListener((Animator.AnimatorListener)this.animationEndListener);
        }
    }
}

