/*
 * Decompiled with CFR 0.152.
 */
package oxim.digital.rx2anim;

import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;
import oxim.digital.rx2anim.RxAnimationBuilder;
import oxim.digital.rx2anim.RxAnimations$$Lambda$1;
import oxim.digital.rx2anim.RxAnimations$$Lambda$10;
import oxim.digital.rx2anim.RxAnimations$$Lambda$11;
import oxim.digital.rx2anim.RxAnimations$$Lambda$12;
import oxim.digital.rx2anim.RxAnimations$$Lambda$13;
import oxim.digital.rx2anim.RxAnimations$$Lambda$14;
import oxim.digital.rx2anim.RxAnimations$$Lambda$15;
import oxim.digital.rx2anim.RxAnimations$$Lambda$16;
import oxim.digital.rx2anim.RxAnimations$$Lambda$17;
import oxim.digital.rx2anim.RxAnimations$$Lambda$18;
import oxim.digital.rx2anim.RxAnimations$$Lambda$19;
import oxim.digital.rx2anim.RxAnimations$$Lambda$20;
import oxim.digital.rx2anim.RxAnimations$$Lambda$21;
import oxim.digital.rx2anim.RxAnimations$$Lambda$22;
import oxim.digital.rx2anim.RxAnimations$$Lambda$4;
import oxim.digital.rx2anim.RxAnimations$$Lambda$5;
import oxim.digital.rx2anim.RxAnimations$$Lambda$6;
import oxim.digital.rx2anim.RxAnimations$$Lambda$7;
import oxim.digital.rx2anim.RxAnimations$$Lambda$8;
import oxim.digital.rx2anim.RxAnimations$$Lambda$9;

public final class RxAnimations {
    private static final float OPAQUE = 1.0f;
    private static final float TRANSPARENT = 0.0f;
    private static final int IMMEDIATE = 0;

    public static Completable animateTogether(CompletableSource ... completables) {
        return Completable.mergeArray((CompletableSource[])completables);
    }

    public static Completable hide(View view) {
        return RxAnimationBuilder.animate(view, 0).fadeOut().schedule();
    }

    public static Completable hide(View ... views) {
        return Observable.fromArray((Object[])views).flatMapCompletable(RxAnimations$$Lambda$1.lambdaFactory$());
    }

    public static Completable hideViewGroupChildren(ViewGroup viewGroup) {
        return Completable.fromAction((Action)RxAnimations$$Lambda$4.lambdaFactory$(viewGroup));
    }

    public static Completable hideViewGroupChildren(ViewGroup ... viewGroups) {
        return Observable.fromArray((Object[])viewGroups).flatMapCompletable(RxAnimations$$Lambda$5.lambdaFactory$());
    }

    private static void hideViewGroup(ViewGroup viewGroup) {
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = viewGroup.getChildAt(i);
            if (child instanceof ViewGroup) {
                RxAnimations.hideViewGroup((ViewGroup)child);
                continue;
            }
            child.setAlpha(0.0f);
        }
    }

    public static Completable show(View view) {
        return RxAnimationBuilder.animate(view, 0).fadeIn().schedule();
    }

    public static Completable fadeIn(View view) {
        return RxAnimationBuilder.animate(view).fadeIn().onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$6.lambdaFactory$()).schedule();
    }

    public static Completable fadeIn(View view, int duration) {
        return RxAnimationBuilder.animate(view, (Interpolator)new DecelerateInterpolator()).duration(duration).fadeIn().onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$7.lambdaFactory$()).schedule();
    }

    public static Completable fadeIn(View view, int duration, int delay) {
        return RxAnimationBuilder.animate(view, duration, delay).interpolator((Interpolator)new DecelerateInterpolator()).fadeIn().onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$8.lambdaFactory$()).schedule();
    }

    public static Completable fadeInWithDelay(int delay, int duration, View ... views) {
        return Observable.range((int)0, (int)views.length).flatMapCompletable(RxAnimations$$Lambda$9.lambdaFactory$(views, duration, delay));
    }

    public static Completable slideHorizontal(View view, int duration, int xOffset) {
        float endingX = view.getX() + (float)xOffset;
        return RxAnimationBuilder.animate(view, (Interpolator)new AccelerateDecelerateInterpolator()).duration(duration).translateBy(xOffset, 0).onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$10.lambdaFactory$(endingX)).schedule(false);
    }

    public static Completable slideVertical(View view, int duration, int yOffset) {
        float endingY = view.getY() + (float)yOffset;
        return RxAnimationBuilder.animate(view, (Interpolator)new AccelerateDecelerateInterpolator()).duration(duration).translateBy(0, yOffset).onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$11.lambdaFactory$(endingY)).schedule(false);
    }

    public static Completable enter(View view, int xOffset, int yOffset) {
        float startingX = view.getX();
        float startingY = view.getY();
        return RxAnimationBuilder.animate(view, (Interpolator)new DecelerateInterpolator()).fadeIn().translateBy(xOffset, yOffset).onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$12.lambdaFactory$(startingX, startingY)).schedule();
    }

    public static Completable enter(View view, int delay, int xOffset, int yOffset) {
        float startingX = view.getX();
        float startingY = view.getY();
        return RxAnimationBuilder.animate(view, (Interpolator)new DecelerateInterpolator()).delay(delay).fadeIn().translateBy(xOffset, yOffset).onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$13.lambdaFactory$(startingX, startingY)).schedule();
    }

    public static Completable enter(View view, int duration, int xOffset, int yOffset, int delay) {
        float startingX = view.getX();
        float startingY = view.getY();
        return RxAnimationBuilder.animate(view, duration, delay).interpolator((Interpolator)new DecelerateInterpolator()).fadeIn().translateBy(xOffset, yOffset).onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$14.lambdaFactory$(startingX, startingY)).schedule();
    }

    public static Completable enterTogether(int xOffset, View ... views) {
        return Observable.fromArray((Object[])views).flatMapCompletable(RxAnimations$$Lambda$15.lambdaFactory$(xOffset));
    }

    public static Completable enterTogether(int delay, int xOffset, View ... views) {
        return RxAnimations.doAfterDelay(delay, Observable.fromArray((Object[])views).flatMapCompletable(RxAnimations$$Lambda$16.lambdaFactory$(xOffset)));
    }

    public static Completable enterViewsWithDelay(int delay, int duration, int xOffset, View ... views) {
        return RxAnimations.enterViewsWithDelay(0, delay, duration, xOffset, views);
    }

    public static Completable enterViewsWithDelay(int initialDelay, int delay, int duration, int xOffset, View ... views) {
        return Observable.range((int)0, (int)views.length).flatMapCompletable(RxAnimations$$Lambda$17.lambdaFactory$(views, duration, xOffset, delay, initialDelay));
    }

    public static Completable enterWithRotation(View view, int duration, int xOffset, int yOffset, int delay, int rotation) {
        float startingX = view.getX();
        float startingY = view.getY();
        float startRotation = view.getRotation();
        return RxAnimationBuilder.animate(view, duration, delay).fadeIn().counterRotateBy(rotation).translateBy(xOffset, yOffset).onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$18.lambdaFactory$(startingX, startingY, startRotation)).schedule();
    }

    public static Completable leave(View view, int xOffset, int yOffset) {
        float startingX = view.getX();
        float startingY = view.getY();
        return RxAnimationBuilder.animate(view, (Interpolator)new AccelerateInterpolator()).fadeOut().translateBy(xOffset, yOffset).onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$19.lambdaFactory$(startingX, startingY)).schedule(false);
    }

    public static Completable fadeOut(View view) {
        return RxAnimationBuilder.animate(view, (Interpolator)new AccelerateInterpolator()).fadeOut().onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$20.lambdaFactory$()).schedule();
    }

    public static Completable fadeOut(View view, int duration) {
        return RxAnimationBuilder.animate(view, (Interpolator)new AccelerateInterpolator()).duration(duration).fadeOut().onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$21.lambdaFactory$()).schedule();
    }

    public static Completable fadeOut(View view, int duration, int delay) {
        return RxAnimationBuilder.animate(view, duration, delay).interpolator((Interpolator)new AccelerateInterpolator()).fadeOut().onAnimationCancel((Consumer<View>)RxAnimations$$Lambda$22.lambdaFactory$()).schedule();
    }

    public static Completable doAfterDelay(int delay, Action action) {
        return Completable.timer((long)delay, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).concatWith((CompletableSource)Completable.fromAction((Action)action));
    }

    public static Completable doAfterDelay(int delay, Completable completable) {
        return Completable.timer((long)delay, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).concatWith((CompletableSource)completable);
    }

    public static void set(View view, float x, float y, float alpha) {
        view.setAlpha(alpha);
        view.setX(x);
        view.setY(y);
    }

    public static void set(View view, float x, float y, float alpha, float rotation) {
        RxAnimations.set(view, x, y, alpha);
        view.setRotation(rotation);
    }

    static /* synthetic */ void lambda$fadeOut$43(View aView) throws Exception {
        aView.setAlpha(0.0f);
    }

    static /* synthetic */ void lambda$fadeOut$42(View aView) throws Exception {
        aView.setAlpha(0.0f);
    }

    static /* synthetic */ void lambda$fadeOut$41(View aView) throws Exception {
        aView.setAlpha(0.0f);
    }

    static /* synthetic */ void lambda$leave$40(float startingX, float startingY, View aView) throws Exception {
        RxAnimations.set(aView, startingX, startingY, 0.0f);
    }

    static /* synthetic */ void lambda$enterWithRotation$39(float startingX, float startingY, float startRotation, View aView) throws Exception {
        RxAnimations.set(aView, startingX, startingY, 1.0f, startRotation);
    }

    static /* synthetic */ CompletableSource lambda$enterViewsWithDelay$38(View[] views, int duration, int xOffset, int delay, int initialDelay, Integer i) throws Exception {
        return RxAnimations.enter(views[i], duration, xOffset, 0, i * delay + initialDelay);
    }

    static /* synthetic */ CompletableSource lambda$enterTogether$37(int xOffset, View view) throws Exception {
        return RxAnimations.enter(view, xOffset, 0);
    }

    static /* synthetic */ CompletableSource lambda$enterTogether$36(int xOffset, View view) throws Exception {
        return RxAnimations.enter(view, xOffset, 0);
    }

    static /* synthetic */ void lambda$enter$35(float startingX, float startingY, View aView) throws Exception {
        RxAnimations.set(aView, startingX, startingY, 1.0f);
    }

    static /* synthetic */ void lambda$enter$34(float startingX, float startingY, View aView) throws Exception {
        RxAnimations.set(aView, startingX, startingY, 1.0f);
    }

    static /* synthetic */ void lambda$enter$33(float startingX, float startingY, View aView) throws Exception {
        RxAnimations.set(aView, startingX, startingY, 1.0f);
    }

    static /* synthetic */ void lambda$slideVertical$32(float endingY, View v) throws Exception {
        v.setY(endingY);
    }

    static /* synthetic */ void lambda$slideHorizontal$31(float endingX, View v) throws Exception {
        v.setX(endingX);
    }

    static /* synthetic */ CompletableSource lambda$fadeInWithDelay$30(View[] views, int duration, int delay, Integer i) throws Exception {
        return RxAnimationBuilder.animate(views[i], (Interpolator)new LinearInterpolator()).duration(duration).delay(i * delay).fadeIn().schedule();
    }

    static /* synthetic */ void lambda$fadeIn$29(View aView) throws Exception {
        aView.setAlpha(1.0f);
    }

    static /* synthetic */ void lambda$fadeIn$28(View aView) throws Exception {
        aView.setAlpha(1.0f);
    }

    static /* synthetic */ void lambda$fadeIn$27(View aView) throws Exception {
        aView.setAlpha(1.0f);
    }

    static /* synthetic */ void lambda$hideViewGroupChildren$26(ViewGroup viewGroup) throws Exception {
        RxAnimations.hideViewGroup(viewGroup);
    }
}

