/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.acegi;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.NullWriter;
import org.zkoss.lang.Exceptions;
import org.zkoss.web.servlet.BufferedResponse;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadCleanup;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.EventThreadResume;
import org.zkoss.zkplus.spring.SpringUtil;

public class AcegiSecurityContextListener
implements EventThreadInit,
EventThreadCleanup,
EventThreadResume {
    private static final Logger log = LoggerFactory.getLogger(AcegiSecurityContextListener.class);
    private SecurityContext _context;
    private final boolean _enabled;

    public AcegiSecurityContextListener() {
        WebApp app = Executions.getCurrent().getDesktop().getWebApp();
        this._enabled = app.getConfiguration().isEventThreadEnabled();
    }

    public void prepare(Component comp, Event evt) {
        if (this._enabled) {
            this._context = SecurityContextHolder.getContext();
        }
    }

    public boolean init(Component comp, Event evt) {
        if (this._enabled) {
            SecurityContextHolder.setContext((SecurityContext)this._context);
            this._context = null;
        }
        return true;
    }

    public void cleanup(Component comp, Event evt, List errs) {
        Throwable ex;
        if (!this._enabled) {
            return;
        }
        this._context = SecurityContextHolder.getContext();
        Execution exec = Executions.getCurrent();
        if (errs != null && !errs.isEmpty() && errs.size() == 1 && (ex = (Throwable)errs.get(0)) != null && (ex = Exceptions.findCause((Throwable)ex, AcegiSecurityException.class)) instanceof AcegiSecurityException) {
            errs.clear();
            exec.setAttribute("org.zkoss.zkplus.acegi.EXCEPTION", (Object)ex);
            exec.setAttribute("org.zkoss.zkplus.acegi.COMPONENT", (Object)comp);
            exec.setAttribute("org.zkoss.zkplus.acegi.EVENT", (Object)evt);
        }
        if (errs != null && !errs.isEmpty()) {
            return;
        }
        exec.setAttribute("org.zkoss.zkplus.acegi.CURRENT_EVENT", (Object)evt);
        Filter filter = (Filter)SpringUtil.getBean("zkFilterChainProxy");
        if (filter != null) {
            ServletRequest request = (ServletRequest)exec.getNativeRequest();
            ServletResponse response = (ServletResponse)exec.getNativeResponse();
            ServletResponse resp = BufferedResponse.getInstance((ServletResponse)response, (Writer)new NullWriter());
            try {
                filter.doFilter(request, resp, (FilterChain)new NullFilterChain());
            }
            catch (Exception ex1) {
                throw UiException.Aide.wrap((Throwable)ex1);
            }
            this._context = SecurityContextHolder.getContext();
        }
    }

    public void complete(Component comp, Event evt) {
        if (this._enabled) {
            SecurityContextHolder.setContext((SecurityContext)this._context);
            this._context = null;
        }
    }

    public void beforeResume(Component comp, Event evt) {
        if (this._enabled) {
            this._context = SecurityContextHolder.getContext();
        }
    }

    public void afterResume(Component comp, Event evt) {
        if (this._enabled) {
            SecurityContextHolder.setContext((SecurityContext)this._context);
            this._context = null;
        }
    }

    public void abortResume(Component comp, Event evt) {
    }

    private static class NullFilterChain
    implements FilterChain {
        private NullFilterChain() {
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        }
    }
}

