/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.spring;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.SystemException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadCleanup;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.EventThreadResume;
import org.zkoss.zkplus.util.ThreadLocals;

public class SpringTransactionSynchronizationListener
implements EventThreadInit,
EventThreadCleanup,
EventThreadResume {
    private static final Logger log = LoggerFactory.getLogger(SpringTransactionSynchronizationListener.class);
    private Object[] _threadLocals = null;
    private final boolean _enabled;

    public SpringTransactionSynchronizationListener() {
        WebApp app = Executions.getCurrent().getDesktop().getWebApp();
        this._enabled = app.getConfiguration().isEventThreadEnabled();
    }

    public void prepare(Component comp, Event evt) {
        if (this._enabled) {
            this.getThreadLocals();
        }
    }

    public boolean init(Component comp, Event evt) {
        if (this._enabled) {
            this.setThreadLocals();
        }
        return true;
    }

    public void cleanup(Component comp, Event evt, List errs) {
        if (this._enabled) {
            this.getThreadLocals();
        }
    }

    public void complete(Component comp, Event evt) {
        if (this._enabled) {
            this.setThreadLocals();
        }
    }

    public void beforeResume(Component comp, Event evt) {
        if (this._enabled) {
            this.getThreadLocals();
        }
    }

    public void afterResume(Component comp, Event evt) {
        if (this._enabled) {
            this.setThreadLocals();
        }
    }

    public void abortResume(Component comp, Event evt) {
    }

    private void getThreadLocals() {
        block7: {
            try {
                Class cls = Classes.forNameByThread((String)"org.springframework.transaction.support.TransactionSynchronizationManager");
                this._threadLocals = new Object[7];
                this._threadLocals[0] = this.getThreadLocal(cls, "resources").get();
                this._threadLocals[1] = this.getThreadLocal(cls, "synchronizations").get();
                this._threadLocals[2] = this.getThreadLocal(cls, "currentTransactionName").get();
                this._threadLocals[3] = this.getThreadLocal(cls, "currentTransactionReadOnly").get();
                this._threadLocals[4] = this.getThreadLocal(cls, "actualTransactionActive").get();
                try {
                    cls = Classes.forNameByThread((String)"org.springframework.orm.hibernate3.SessionFactoryUtils");
                    this._threadLocals[5] = this.getThreadLocal(cls, "deferredCloseHolder").get();
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                cls = Classes.forNameByThread((String)"org.springframework.transaction.interceptor.TransactionAspectSupport");
                try {
                    this._threadLocals[6] = this.getThreadLocal(cls, "transactionInfoHolder").get();
                }
                catch (SystemException ex) {
                    if (ex.getCause() instanceof NoSuchFieldException) {
                        this._threadLocals[6] = this.getThreadLocal(cls, "currentTransactionInfo").get();
                        break block7;
                    }
                    throw ex;
                }
            }
            catch (ClassNotFoundException ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
    }

    private void setThreadLocals() {
        if (this._threadLocals != null) {
            try {
                Class cls = Classes.forNameByThread((String)"org.springframework.transaction.support.TransactionSynchronizationManager");
                this.getThreadLocal(cls, "resources").set(this._threadLocals[0]);
                this.getThreadLocal(cls, "synchronizations").set(this._threadLocals[1]);
                this.getThreadLocal(cls, "currentTransactionName").set(this._threadLocals[2]);
                this.getThreadLocal(cls, "currentTransactionReadOnly").set(this._threadLocals[3]);
                this.getThreadLocal(cls, "actualTransactionActive").set(this._threadLocals[4]);
                try {
                    cls = Classes.forNameByThread((String)"org.springframework.orm.hibernate3.SessionFactoryUtils");
                    this.getThreadLocal(cls, "deferredCloseHolder").set(this._threadLocals[5]);
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                cls = Classes.forNameByThread((String)"org.springframework.transaction.interceptor.TransactionAspectSupport");
                try {
                    this.getThreadLocal(cls, "transactionInfoHolder").set(this._threadLocals[6]);
                }
                catch (SystemException ex) {
                    if (ex.getCause() instanceof NoSuchFieldException) {
                        this.getThreadLocal(cls, "currentTransactionInfo").set(this._threadLocals[6]);
                    }
                    throw ex;
                }
                this._threadLocals = null;
            }
            catch (ClassNotFoundException ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
    }

    private ThreadLocal getThreadLocal(Class cls, String fldname) {
        return ThreadLocals.getThreadLocal(cls, fldname);
    }
}

