/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.databind;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Primitives;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.zk.scripting.HierachicalAware;
import org.zkoss.zk.scripting.Interpreter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.CreateEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zkplus.databind.Binding;
import org.zkoss.zkplus.databind.BindingListModel;
import org.zkoss.zkplus.databind.BindingListModelExt;
import org.zkoss.zkplus.databind.BindingNode;
import org.zkoss.zkplus.databind.CollectionItem;
import org.zkoss.zkplus.databind.CollectionItemExt;
import org.zkoss.zkplus.databind.ComboitemCollectionItem;
import org.zkoss.zkplus.databind.ListitemCollectionItem;
import org.zkoss.zkplus.databind.RowCollectionItem;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Grid;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBinder
implements Serializable {
    public static final String LOAD_ON_SAVE_TRIGGER_COMPONENT = "zkoss.DataBinder.LOAD_ON_SAVE_TRIGGER_COMPONENT";
    private static final long serialVersionUID = 200808191508L;
    public static final String NULLIFY = "none";
    public static final String ARGS = "bindingArgs";
    public static final String VARNAME = "zkplus.databind.VARNAME";
    public static final String TEMPLATEMAP = "zkplus.databind.TEMPLATEMAP";
    public static final String TEMPLATE = "zkplus.databind.TEMPLATE";
    private static final String OWNER = "zkplus.databind.OWNER";
    private static final String ITEM = "zkplus.databind.ITEM";
    private static final String IAMOWNER = "zkplus.databind.IAMOWNER";
    private static final String HASTEMPLATEOWNER = "zkplus.databind.HASTEMPLATEOWNER";
    private static final Object NA = new Object();
    private Map<Component, Map<String, Binding>> _compBindingMap = new LinkedHashMap<Component, Map<String, Binding>>(29);
    private Map<String, Object> _beans = new HashMap<String, Object>(29);
    private Map<Object, Set<Object>> _beanSameNodes = new HashMap<Object, Set<Object>>(29);
    private BindingNode _pathTree = new BindingNode("/", false, "/", false);
    private boolean _defaultConfig = true;
    private boolean _init;
    private EventListener _listener = new LoadOnSaveEventListener();
    protected Map<String, CollectionItem> _collectionItemMap = new HashMap<String, CollectionItem>(3);
    protected Map<String, CollectionItem> _collectionOwnerMap = new HashMap<String, CollectionItem>(3);
    private boolean _loadOnSave = true;

    public void setLoadOnSave(boolean b) {
        this._loadOnSave = b;
    }

    public boolean isLoadOnSave() {
        return this._loadOnSave;
    }

    public void addBinding(Component comp, String attr, String expr) {
        this.addBinding(comp, attr, expr, (List<String>)null, (List<String>)null, null, null);
    }

    public void addBinding(Component comp, String attr, String expr, String[] loadWhenEvents, String saveWhenEvent, String access, String converter) {
        ArrayList<String> loadEvents = null;
        if (loadWhenEvents != null && loadWhenEvents.length > 0) {
            loadEvents = new ArrayList<String>(loadWhenEvents.length);
            for (int j = 0; j < loadWhenEvents.length; ++j) {
                loadEvents.add(loadWhenEvents[j]);
            }
        }
        this.addBinding(comp, attr, expr, loadEvents, saveWhenEvent, access, converter);
    }

    public void addBinding(Component comp, String attr, String expr, String[] loadWhenEvents, String[] saveWhenEvents, String access, String converter) {
        ArrayList<String> loadEvents = null;
        if (loadWhenEvents != null && loadWhenEvents.length > 0) {
            loadEvents = new ArrayList<String>(loadWhenEvents.length);
            for (int j = 0; j < loadWhenEvents.length; ++j) {
                loadEvents.add(loadWhenEvents[j]);
            }
        }
        ArrayList<String> saveEvents = null;
        if (saveWhenEvents != null && saveWhenEvents.length > 0) {
            saveEvents = new ArrayList<String>(saveWhenEvents.length);
            for (int j = 0; j < saveWhenEvents.length; ++j) {
                saveEvents.add(saveWhenEvents[j]);
            }
        }
        this.addBinding(comp, attr, expr, loadEvents, saveEvents, access, converter);
    }

    public void addBinding(Component comp, String attr, String expr, List<String> loadWhenEvents, String saveWhenEvent, String access, String converter) {
        ArrayList<String> saveEvents = new ArrayList<String>();
        saveEvents.add(saveWhenEvent);
        this.addBinding(comp, attr, expr, loadWhenEvents, saveEvents, access, converter);
    }

    public void addBinding(Component comp, String attr, String expr, List<String> loadWhenEvents, List<String> saveWhenEvents, String access, String converter) {
        this.addBinding(comp, attr, expr, loadWhenEvents, saveWhenEvents, access, converter, null, null, null);
    }

    public void addBinding(Component comp, String attr, String expr, List<String> loadWhenEvents, List<String> saveWhenEvents, String access, String converter, Map<Object, Object> args, List<String> loadAfterEvents, List<String> saveAfterEvents) {
        Map<String, Binding> attrMap;
        if ("each".equals(attr)) {
            attr = "_var";
        }
        if (this.isDefaultConfig()) {
            Object[] objs = this.loadPropertyAnnotation(comp, attr, "default-bind");
            if (loadWhenEvents == null && objs[1] != null) {
                loadWhenEvents = Generics.cast((List)((List)objs[1]));
            }
            if (saveWhenEvents == null && objs[2] != null) {
                saveWhenEvents = Generics.cast((List)((List)objs[2]));
            }
            if (access == null && objs[3] != null) {
                access = (String)objs[3];
            }
            if (converter == null && objs[4] != null) {
                converter = (String)objs[4];
            }
            if (args == null && objs[5] != null) {
                args = Generics.cast((Map)((Map)objs[5]));
            }
            if (loadAfterEvents == null && objs[6] != null) {
                loadAfterEvents = Generics.cast((List)((List)objs[6]));
            }
            if (saveAfterEvents == null && objs[7] != null) {
                saveAfterEvents = Generics.cast((List)((List)objs[7]));
            }
        }
        LinkedHashSet<String> loadEvents = null;
        if (loadWhenEvents != null && loadWhenEvents.size() > 0) {
            loadEvents = new LinkedHashSet<String>(loadWhenEvents.size());
            for (String event : loadWhenEvents) {
                if (NULLIFY.equals(event)) {
                    loadEvents.clear();
                    continue;
                }
                loadEvents.add(event);
            }
            if (loadEvents.isEmpty()) {
                loadEvents = null;
            }
        }
        LinkedHashSet<String> lafterEvents = null;
        if (loadAfterEvents != null && loadAfterEvents.size() > 0) {
            lafterEvents = new LinkedHashSet<String>(loadAfterEvents.size());
            for (String event : loadAfterEvents) {
                if (NULLIFY.equals(event)) {
                    lafterEvents.clear();
                    continue;
                }
                lafterEvents.add(event);
            }
            if (lafterEvents.isEmpty()) {
                lafterEvents = null;
            }
        }
        LinkedHashSet<String> saveEvents = null;
        if (saveWhenEvents != null && saveWhenEvents.size() > 0) {
            saveEvents = new LinkedHashSet<String>(saveWhenEvents.size());
            for (String event : saveWhenEvents) {
                if (NULLIFY.equals(event)) {
                    saveEvents.clear();
                    continue;
                }
                saveEvents.add(event);
            }
            if (saveEvents.isEmpty()) {
                saveEvents = null;
            }
        }
        LinkedHashSet<String> safterEvents = null;
        if (saveAfterEvents != null && saveAfterEvents.size() > 0) {
            safterEvents = new LinkedHashSet<String>(saveAfterEvents.size());
            for (String event : saveAfterEvents) {
                if (NULLIFY.equals(event)) {
                    safterEvents.clear();
                    continue;
                }
                safterEvents.add(event);
            }
            if (safterEvents.isEmpty()) {
                safterEvents = null;
            }
        }
        if (NULLIFY.equals(converter)) {
            converter = null;
        }
        if ((attrMap = this._compBindingMap.get(comp)) == null) {
            attrMap = new LinkedHashMap<String, Binding>(3);
            this._compBindingMap.put(comp, attrMap);
        }
        if (attrMap.containsKey(attr)) {
            Binding binding = attrMap.get(attr);
            binding.setExpression(expr);
            binding.setLoadWhenEvents(loadEvents);
            binding.setLoadAfterEvents(lafterEvents);
            binding.setSaveWhenEvents(saveEvents);
            binding.setSaveAfterEvents(safterEvents);
            binding.setAccess(access);
            binding.setConverter(converter);
        } else {
            attrMap.put(attr, new Binding(this, comp, attr, expr, loadEvents, saveEvents, access, converter, args, lafterEvents, safterEvents));
        }
    }

    public void removeBinding(Component comp, String attr) {
        Map<String, Binding> attrMap;
        if (DataBinder.isClone(comp)) {
            comp = (Component)comp.getAttribute(TEMPLATE);
        }
        if ((attrMap = this._compBindingMap.get(comp)) != null) {
            attrMap.remove(attr);
        }
    }

    public Binding getBinding(Component comp, String attr) {
        Map<String, Binding> attrMap;
        if (DataBinder.isClone(comp)) {
            comp = (Component)comp.getAttribute(TEMPLATE);
        }
        return (attrMap = this._compBindingMap.get(comp)) != null ? attrMap.get(attr) : null;
    }

    public Collection<Binding> getBindings(Component comp) {
        Map<String, Binding> attrMap;
        if (DataBinder.isClone(comp)) {
            comp = (Component)comp.getAttribute(TEMPLATE);
        }
        return (attrMap = this._compBindingMap.get(comp)) != null ? attrMap.values() : null;
    }

    public Collection<Binding> getAllBindings() {
        ArrayList<Binding> bindings = new ArrayList<Binding>(this._compBindingMap.size() * 2);
        for (Map<String, Binding> map : this._compBindingMap.values()) {
            bindings.addAll(map.values());
        }
        return bindings;
    }

    public boolean existsBindings(Component comp) {
        if (DataBinder.isClone(comp)) {
            comp = (Component)comp.getAttribute(TEMPLATE);
        }
        return this._compBindingMap.containsKey(comp);
    }

    public boolean existBinding(Component comp, String attr) {
        if (DataBinder.isClone(comp)) {
            comp = (Component)comp.getAttribute(TEMPLATE);
        }
        if (this._compBindingMap.containsKey(comp)) {
            Map<String, Binding> attrMap = this._compBindingMap.get(comp);
            return attrMap.containsKey(attr);
        }
        return false;
    }

    public boolean isDefaultConfig() {
        return this._defaultConfig;
    }

    public void setDefaultConfig(boolean b) {
        this._defaultConfig = b;
    }

    public void bindBean(String beanid, Object bean) {
        this._beans.put(beanid, bean);
    }

    public void loadAttribute(Component comp, String attr) {
        if (DataBinder.isTemplate(comp) || comp.getPage() == null) {
            return;
        }
        this.init();
        Binding binding = this.getBinding(comp, attr);
        if (binding != null) {
            binding.loadAttribute(comp);
        }
    }

    public void saveAttribute(Component comp, String attr) {
        if (DataBinder.isTemplate(comp) || comp.getPage() == null) {
            return;
        }
        this.init();
        Binding binding = this.getBinding(comp, attr);
        if (binding != null) {
            binding.saveAttribute(comp);
        }
    }

    public void loadComponent(Component comp) {
        this.init();
        if (this.loadComponent0(comp)) {
            return;
        }
        Iterator it = comp.getChildren().iterator();
        while (it.hasNext()) {
            this.loadComponent((Component)it.next());
        }
    }

    private boolean loadComponent0(Component comp) {
        if (DataBinder.isTemplate(comp) || comp.getPage() == null) {
            return true;
        }
        Collection<Binding> bindings = this.getBindings(comp);
        if (bindings != null) {
            this.loadAttrs(comp, bindings);
        }
        return false;
    }

    public void saveComponent(Component comp) {
        if (DataBinder.isTemplate(comp) || comp.getPage() == null) {
            return;
        }
        this.init();
        Collection<Binding> bindings = this.getBindings(comp);
        if (bindings != null) {
            this.saveAttrs(comp, bindings);
        }
        Iterator it = comp.getChildren().iterator();
        while (it.hasNext()) {
            this.saveComponent((Component)it.next());
        }
    }

    public void loadAll() {
        this.init();
        for (Component comp : this._compBindingMap.keySet()) {
            this.loadComponent0(comp);
        }
    }

    public void saveAll() {
        this.init();
        for (Component comp : this._compBindingMap.keySet()) {
            this.saveComponent(comp);
        }
    }

    private void loadAttrs(Component comp, Collection attrs) {
        for (Binding binding : attrs) {
            binding.loadAttribute(comp);
        }
    }

    private void saveAttrs(Component comp, Collection attrs) {
        for (Binding binding : attrs) {
            binding.saveAttribute(comp);
        }
    }

    protected Object[] loadPropertyAnnotation(Component comp, String propName, String bindName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = compCtrl.getAnnotation(propName, bindName);
        if (ann != null) {
            Map attrs = ann.getAttributes();
            List<String> loadWhenEvents = null;
            List<String> saveWhenEvents = null;
            List<String> loadAfterEvents = null;
            List<String> saveAfterEvents = null;
            String access = null;
            String converter = null;
            String expr = null;
            HashMap<String, String> args = null;
            for (Map.Entry entry : attrs.entrySet()) {
                String tag = (String)entry.getKey();
                String[] tagval = (String[])entry.getValue();
                String tagExpr = tagval[tagval.length - 1];
                if ("save-when".equals(tag)) {
                    saveWhenEvents = DataBinder.parseExpression(tagExpr, ",");
                    continue;
                }
                if ("load-after".equals(tag)) {
                    loadAfterEvents = DataBinder.parseExpression(tagExpr, ",");
                    continue;
                }
                if ("access".equals(tag)) {
                    access = tagExpr;
                    continue;
                }
                if ("converter".equals(tag)) {
                    converter = tagExpr;
                    continue;
                }
                if ("load-when".equals(tag)) {
                    loadWhenEvents = DataBinder.parseExpression(tagExpr, ",");
                    continue;
                }
                if ("save-after".equals(tag)) {
                    saveAfterEvents = DataBinder.parseExpression(tagExpr, ",");
                    continue;
                }
                if ("value".equals(tag)) {
                    expr = tagExpr;
                    continue;
                }
                if (args == null) {
                    args = new HashMap<String, String>();
                }
                args.put(tag, tagExpr);
            }
            return new Object[]{expr, loadWhenEvents, saveWhenEvents, access, converter, args, loadAfterEvents, saveAfterEvents};
        }
        return new Object[8];
    }

    protected void init() {
        if (!this._init) {
            this._init = true;
            this.initCollectionItem();
            HashSet<String> varnameSet = new HashSet<String>();
            LinkedHashSet<Component> toBeDetached = new LinkedHashSet<Component>();
            for (Map.Entry<Component, Map<String, Binding>> me : this._compBindingMap.entrySet()) {
                Component comp = me.getKey();
                Map<String, Binding> attrMap = me.getValue();
                Collection<Binding> bindings = attrMap.values();
                if (attrMap.containsKey("_var")) {
                    comp.setAttribute(ITEM, (Object)comp);
                    Component owner = this.getComponentCollectionOwner(comp);
                    owner.setAttribute(IAMOWNER, (Object)Boolean.TRUE);
                    this.setupTemplateComponent(comp, owner);
                    String varname = attrMap.get("_var").getExpression();
                    varnameSet.add(varname);
                    comp.setAttribute(VARNAME, (Object)varname);
                    this.setupBindingRenderer(comp);
                    toBeDetached.add(comp);
                }
                if (bindings == null) continue;
                this.setupPathTree(bindings, varnameSet);
                this.registerSaveEvents(comp, bindings);
                this.registerLoadEvents(comp, bindings);
            }
            for (Component comp : toBeDetached) {
                comp.detach();
            }
        }
    }

    private void initCollectionItem() {
        this.addCollectionItem(Listitem.class, Listbox.class, new ListitemCollectionItem());
        this.addCollectionItem(Row.class, Grid.class, new RowCollectionItem());
        this.addCollectionItem(Comboitem.class, Combobox.class, new ComboitemCollectionItem());
    }

    public void addCollectionItem(Class item, Class owner, CollectionItem decor) {
        this._collectionItemMap.put(item.getName(), decor);
        this._collectionOwnerMap.put(owner.getName(), decor);
    }

    private Component getComponentCollectionOwner(Component comp) {
        CollectionItem decor = this.getBindingCollectionItem(comp);
        return decor.getComponentCollectionOwner(comp);
    }

    protected CollectionItem getBindingCollectionItem(Component comp) {
        String name = comp.getClass().getName();
        if (comp instanceof Listitem) {
            name = Listitem.class.getName();
        } else if (comp instanceof Row) {
            name = Row.class.getName();
        } else if (comp instanceof Comboitem) {
            name = Comboitem.class.getName();
        }
        CollectionItem decorName = this._collectionItemMap.get(name);
        if (decorName != null) {
            return decorName;
        }
        throw new UiException("Cannot find associated CollectionItem:" + comp);
    }

    CollectionItem getCollectionItemByOwner(Component comp) {
        CollectionItem decorName = this.myGetCollectionItemByOwner(comp);
        if (decorName == null) {
            throw new UiException("Cannot find associated CollectionItem by owner: " + comp);
        }
        return decorName;
    }

    private CollectionItem myGetCollectionItemByOwner(Component comp) {
        String name = comp.getClass().getName();
        if (comp instanceof Listbox) {
            name = Listbox.class.getName();
        } else if (comp instanceof Grid) {
            name = Grid.class.getName();
        } else if (comp instanceof Combobox) {
            name = Combobox.class.getName();
        }
        CollectionItem decorName = this._collectionOwnerMap.get(name);
        return decorName;
    }

    Component getCollectionOwner(Component comp) {
        if (DataBinder.isTemplate(comp)) {
            return (Component)comp.getAttribute(OWNER);
        }
        return this.getComponentCollectionOwner(comp);
    }

    private Component getCollectionItem(Component comp, Object bean, boolean isCollectionItem) {
        Component[] comps = this.getCollectionItems(comp, bean, isCollectionItem);
        return comps.length == 0 ? null : comps[0];
    }

    private Component[] getCollectionItems(Component comp, Object bean, boolean isCollectionItem) {
        Component owner = this.getCollectionOwner(comp);
        Component item = (Component)comp.getAttribute(ITEM);
        CollectionItem decor = this.myGetCollectionItemByOwner(owner);
        if (decor == null) {
            decor = this.getBindingCollectionItem(item);
        }
        ListModel xmodel = decor.getModelByOwner(owner);
        if (isCollectionItem && comp == item) {
            BindingListModel model;
            int index;
            if (xmodel instanceof BindingListModelExt && !((BindingListModelExt)xmodel).isDistinct()) {
                BindingListModelExt model2 = (BindingListModelExt)xmodel;
                int[] indexes = model2.indexesOf(bean);
                int sz = indexes.length;
                ArrayList<Component> comps = new ArrayList<Component>(sz);
                for (int j = 0; j < sz; ++j) {
                    Component xcomp = DataBinder.lookupClone(decor.getComponentAtIndexByOwner(owner, indexes[j]), comp);
                    if (xcomp == null) continue;
                    comps.add(xcomp);
                }
                return comps.toArray(new Component[comps.size()]);
            }
            if (xmodel instanceof BindingListModel && (index = (model = (BindingListModel)xmodel).indexOf(bean)) >= 0) {
                Component[] componentArray;
                Component xcomp = DataBinder.lookupClone(decor.getComponentAtIndexByOwner(owner, index), comp);
                if (xcomp != null) {
                    Component[] componentArray2 = new Component[1];
                    componentArray = componentArray2;
                    componentArray2[0] = xcomp;
                } else {
                    componentArray = new Component[]{};
                }
                return componentArray;
            }
        } else {
            int sz = xmodel.getSize();
            ArrayList<Component> comps = new ArrayList<Component>(sz);
            if (decor instanceof CollectionItemExt) {
                List items = ((CollectionItemExt)decor).getItems(owner);
                for (Component cloneitem : items) {
                    Component xcomp = DataBinder.lookupClone(cloneitem, comp);
                    if (xcomp == null) continue;
                    comps.add(xcomp);
                }
            } else {
                for (int j = 0; j < sz; ++j) {
                    Component xcomp = DataBinder.lookupClone(decor.getComponentAtIndexByOwner(owner, j), comp);
                    if (xcomp == null) continue;
                    comps.add(xcomp);
                }
            }
            return comps.toArray(new Component[sz]);
        }
        return new Component[0];
    }

    private void setupBindingRenderer(Component comp) {
        this.getBindingCollectionItem(comp).setupBindingRenderer(comp, this);
    }

    private void setupPathTree(Collection<Binding> bindings, Set<String> varnameSet) {
        for (Binding binding : bindings) {
            String[] paths = binding.getPaths();
            for (int j = 0; j < paths.length; ++j) {
                String path = paths[j];
                this._pathTree.addBinding(path, binding, varnameSet);
            }
        }
    }

    private void registerSaveEvents(Component comp, Collection bindings) {
        for (Binding binding : bindings) {
            binding.registerSaveEvents(comp);
        }
    }

    private void registerLoadEvents(Component comp, Collection bindings) {
        for (Binding binding : bindings) {
            binding.registerLoadEvents(comp);
        }
    }

    boolean existsBean(String beanid) {
        return this._beans.containsKey(beanid);
    }

    Object getBean(String beanid) {
        return this._beans.get(beanid);
    }

    void setBean(String beanid, Object bean) {
        this._beans.put(beanid, bean);
    }

    public void setupTemplateComponent(Component comp, Object owner) {
        this.mySetupTemplateComponent(comp, owner, comp);
    }

    private void mySetupTemplateComponent(Component comp, Object owner, Component item) {
        if (this.existsBindings(comp)) {
            if (comp.getAttribute(OWNER) != null) {
                comp.setAttribute(HASTEMPLATEOWNER, (Object)Boolean.TRUE);
            }
            comp.setAttribute(OWNER, owner);
            comp.setAttribute(ITEM, (Object)item);
        }
        for (Component c : comp.getChildren()) {
            this.mySetupTemplateComponent(c, owner, item);
        }
    }

    static List<String> parseExpression(String expr, String separator) {
        if (expr == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>(6);
        while (true) {
            int j;
            if ((j = expr.indexOf(separator)) < 0) {
                results.add(expr.trim());
                return results;
            }
            results.add(expr.substring(0, j).trim());
            if (expr.length() <= j + 1) {
                return results;
            }
            expr = expr.substring(j + 1);
        }
    }

    static boolean isCollectionOwner(Component owner) {
        return owner.getAttribute(IAMOWNER) != null;
    }

    static boolean isTemplate(Component comp) {
        return comp != null && comp.getAttribute(OWNER) != null;
    }

    static boolean isClone(Component comp) {
        return comp != null && comp.getAttribute(TEMPLATE) instanceof Component;
    }

    static Component getComponent(Component clone) {
        return (Component)clone.getAttribute(TEMPLATE);
    }

    static boolean hasTemplateOwner(Component comp) {
        return comp != null && comp.getAttribute(HASTEMPLATEOWNER) != null;
    }

    void setBeanSameNodes(Object bean, Set<Object> set) {
        this._beanSameNodes.put(bean, set);
    }

    Set<Object> getBeanSameNodes(Object bean) {
        return this._beanSameNodes.get(bean);
    }

    Set<Object> removeBeanSameNodes(Object bean) {
        return this._beanSameNodes.remove(bean);
    }

    Object getBeanAndRegisterBeanSameNodes(Component comp, String path) {
        return this.myGetBeanWithExpression(comp, path, true);
    }

    Object getBeanWithExpression(Component comp, String path) {
        return this.myGetBeanWithExpression(comp, path, false);
    }

    private Object myGetBeanWithExpression(Component comp, String path, boolean registerNode) {
        String nodeid;
        Object bean = null;
        BindingNode currentNode = this._pathTree;
        List<String> nodeids = DataBinder.parseExpression(path, ".");
        Iterator<String> it = nodeids.iterator();
        if (it != null && it.hasNext()) {
            nodeid = it.next();
            if ((currentNode = currentNode.getKidNode(nodeid)) == null) {
                throw new UiException("Cannot find the specified databind bean expression:" + path);
            }
            bean = this.lookupBean(comp, nodeid);
            if (registerNode) {
                this.registerBeanNode(bean, currentNode);
            }
        } else {
            throw new UiException("Incorrect format of databind bean expression:" + path);
        }
        while (bean != null && it.hasNext()) {
            nodeid = it.next();
            if ((currentNode = currentNode.getKidNode(nodeid)) == null) {
                throw new UiException("Cannot find the specified databind bean expression:" + path);
            }
            bean = this.fetchValue(bean, currentNode, nodeid, registerNode);
        }
        return bean;
    }

    private Object fetchValue(Object bean, BindingNode node, String nodeid, boolean registerNode) {
        if (bean != null) {
            if (bean instanceof Map) {
                bean = ((Map)bean).get(nodeid);
            } else {
                try {
                    bean = Fields.get((Object)bean, (String)nodeid);
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
            }
        }
        if (registerNode) {
            this.registerBeanNode(bean, node);
        }
        return bean;
    }

    void setBeanAndRegisterBeanSameNodes(Component comp, Object val, Binding binding, String path, boolean autoConvert, Object rawval, List<Object> loadOnSaveInfos, String triggerEventName) {
        Object orgVal = null;
        Object bean = null;
        BindingNode currentNode = this._pathTree;
        boolean refChanged = false;
        String beanid = null;
        List<String> nodeids = DataBinder.parseExpression(path, ".");
        ArrayList<BindingNode> nodes = new ArrayList<BindingNode>(nodeids.size());
        Iterator<String> it = nodeids.iterator();
        if (it != null && it.hasNext()) {
            beanid = it.next();
            if ((currentNode = currentNode.getKidNode(beanid)) == null) {
                throw new UiException("Cannot find the specified databind bean expression:" + path);
            }
        } else {
            throw new UiException("Incorrect format of databind bean expression:" + path);
        }
        nodes.add(currentNode);
        bean = this.lookupBean(comp, beanid);
        if (!it.hasNext()) {
            orgVal = bean;
            if (Objects.equals((Object)orgVal, (Object)val)) {
                return;
            }
            if (this.existsBean(beanid)) {
                this.setBean(beanid, val);
            } else if (!this.setZScriptVariable(comp, beanid, val)) {
                comp.getSpaceOwner().setAttribute(beanid, val, true);
            }
            refChanged = true;
        } else {
            if (bean == null) {
                return;
            }
            for (int sz = nodeids.size() - 2; bean != null && it.hasNext() && sz > 0; --sz) {
                beanid = it.next();
                if ((currentNode = currentNode.getKidNode(beanid)) == null) {
                    throw new UiException("Cannot find the specified databind bean expression:" + path);
                }
                nodes.add(currentNode);
                if (bean instanceof Map) {
                    bean = ((Map)bean).get(beanid);
                    continue;
                }
                try {
                    bean = Fields.get((Object)bean, (String)beanid);
                    continue;
                }
                catch (NoSuchMethodException ex) {
                    throw UiException.Aide.wrap((Throwable)ex);
                }
            }
            if (bean == null) {
                return;
            }
            beanid = it.next();
            if (bean instanceof Map) {
                ((Map)bean).put(beanid, val);
            } else {
                try {
                    orgVal = Fields.get((Object)bean, (String)beanid);
                    if (Objects.equals((Object)orgVal, (Object)val)) {
                        return;
                    }
                    Fields.set((Object)bean, (String)beanid, (Object)val, (boolean)autoConvert);
                }
                catch (NoSuchMethodException ex) {
                    throw UiException.Aide.wrap((Throwable)ex);
                }
            }
            if (!this.isPrimitive(val) && !this.isPrimitive(orgVal)) {
                if ((currentNode = currentNode.getKidNode(beanid)) == null) {
                    throw new UiException("Cannot find the specified databind bean expression:" + path);
                }
                nodes.add(currentNode);
                bean = orgVal;
                refChanged = true;
            }
        }
        if (val != null) {
            Binding varbinding;
            if (refChanged && !binding.isLoadable() && binding.isSavable()) {
                this.registerBeanNode(val, currentNode);
            }
            if (rawval instanceof Component && (varbinding = this.getBinding((Component)rawval, "_var")) != null) {
                this.registerBeanNode(val, currentNode);
                this.getBeanAndRegisterBeanSameNodes((Component)rawval, varbinding.getExpression());
            }
        }
        if (!comp.isListenerAvailable("onLoadOnSave", true)) {
            comp.addEventListener("onLoadOnSave", this._listener);
        }
        Object[] loadOnSaveInfo = new Object[]{this, currentNode, binding, refChanged ? val : bean, refChanged, nodes, comp, triggerEventName};
        if (loadOnSaveInfos != null) {
            loadOnSaveInfos.add(loadOnSaveInfo);
        } else if (this.isLoadOnSave()) {
            Events.postEvent((Event)new Event("onLoadOnSave", comp, (Object)loadOnSaveInfo));
        }
    }

    private void registerBeanNode(Object bean, BindingNode node) {
        if (this.isPrimitive(bean)) {
            return;
        }
        Set<Object> nodeSameNodes = node.getSameNodes();
        Set<Object> binderSameNodes = this.getBeanSameNodes(bean);
        if (node.isVar() && binderSameNodes == null) {
            return;
        }
        if (!nodeSameNodes.contains(bean)) {
            Iterator<Object> it = nodeSameNodes.iterator();
            while (it.hasNext()) {
                Object elm = it.next();
                if (elm instanceof BindingNode) continue;
                it.remove();
                this.removeBeanSameNodes(elm);
                break;
            }
            if (bean != null) {
                nodeSameNodes.add(bean);
            }
        }
        if (binderSameNodes == null) {
            if (bean != null) {
                this.setBeanSameNodes(bean, nodeSameNodes);
            }
        } else {
            node.mergeAndSetSameNodes(binderSameNodes);
        }
    }

    private boolean isPrimitive(Object bean) {
        return bean instanceof String || bean != null && Primitives.toPrimitive(bean.getClass()) != null || bean instanceof Date || bean instanceof Number;
    }

    private boolean setZScriptVariable(Component comp, String beanid, Object val) {
        boolean found = false;
        for (Interpreter ip : comp.getPage().getLoadedInterpreters()) {
            if (ip instanceof HierachicalAware) {
                HierachicalAware ha = (HierachicalAware)ip;
                if (!ha.containsVariable((Scope)comp, beanid)) continue;
                ha.setVariable((Scope)comp, beanid, val);
                found = true;
                continue;
            }
            if (!ip.containsVariable(beanid)) continue;
            ip.setVariable(beanid, val);
            found = true;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lookupBean(Component comp, String beanid) {
        Object bean = null;
        if ("self".equals(beanid)) {
            return comp;
        }
        if (DataBinder.isClone(comp) && (bean = this.myLookupBean1(comp, beanid)) != NA) {
            return bean;
        }
        if (this.existsBean(beanid)) {
            bean = this.getBean(beanid);
        } else if (beanid.startsWith("/")) {
            bean = Path.getComponent((String)beanid);
        } else if (beanid.startsWith(".")) {
            bean = Path.getComponent((IdSpace)comp.getSpaceOwner(), (String)beanid);
        } else {
            Page page = comp.getPage();
            if (page != null) {
                bean = Components.getImplicit((Component)comp, (String)beanid);
                if ("param".equals(beanid) && bean != null) {
                    bean = new HashMap(Generics.cast((Map)((Map)bean)));
                }
                if (bean == null && (bean = page.getZScriptVariable(comp, beanid)) == null) {
                    Object self = page.getAttribute("self");
                    try {
                        page.setAttribute("self", (Object)comp);
                        bean = comp.getAttributeOrFellow(beanid, true);
                        if (bean == null) {
                            bean = page.getXelVariable(null, null, (Object)beanid, true);
                        }
                    }
                    finally {
                        if (self == null) {
                            page.removeAttribute("self");
                        } else {
                            page.setAttribute("self", self);
                        }
                    }
                }
            }
        }
        return bean;
    }

    private Object myLookupBean1(Component comp, String beanid) {
        Map templatemap = (Map)comp.getAttribute(TEMPLATEMAP);
        return this.myLookupBean2(beanid, templatemap);
    }

    private Object myLookupBean2(String beanid, Map templatemap) {
        if (templatemap != null) {
            if (templatemap.containsKey(beanid)) {
                return templatemap.get(beanid);
            }
            templatemap = (Map)templatemap.get(TEMPLATEMAP);
            return this.myLookupBean2(beanid, templatemap);
        }
        return NA;
    }

    static Component lookupClone(Component srcClone, Component srcTemplate) {
        if (DataBinder.isTemplate(srcTemplate) && srcClone != null) {
            Map templatemap = (Map)srcClone.getAttribute(TEMPLATEMAP);
            return DataBinder.myLookupClone(srcTemplate, templatemap);
        }
        return null;
    }

    private static Component myLookupClone(Component srcTemplate, Map templatemap) {
        if (templatemap != null) {
            if (templatemap.containsKey(srcTemplate)) {
                return (Component)templatemap.get(srcTemplate);
            }
            templatemap = (Map)templatemap.get(TEMPLATEMAP);
            return DataBinder.myLookupClone(srcTemplate, templatemap);
        }
        return null;
    }

    private Set<Object> getAssociateSameNodes(BindingNode parentNode, String path, int level) {
        List<String> nodeids = DataBinder.parseExpression(path, ".");
        int sz = nodeids.size();
        List<String> subids = nodeids.subList(sz - level, sz);
        for (Object obj : parentNode.getSameNodes()) {
            if (!(obj instanceof BindingNode)) break;
        }
        HashSet<Object> assocateSameNodes = new HashSet<Object>();
        Iterator<Object> it = parentNode.getSameNodes().iterator();
        while (it.hasNext()) {
            String nodeid;
            BindingNode currentNode = null;
            Object obj = it.next();
            if (!(obj instanceof BindingNode) || currentNode == parentNode) continue;
            currentNode = (BindingNode)obj;
            Iterator<String> itx = subids.iterator();
            while (itx.hasNext() && (currentNode = currentNode.getKidNode(nodeid = itx.next())) != null) {
            }
            if (currentNode == null) continue;
            if (!currentNode.isVar()) {
                assocateSameNodes.add(currentNode);
                continue;
            }
            Component varRootComp = this.getVarRootComponent(currentNode);
            assocateSameNodes.add(new Object[]{currentNode, varRootComp});
        }
        return assocateSameNodes;
    }

    private Component getVarRootComponent(BindingNode node) {
        BindingNode varRootNode = node.getRootNode(this._pathTree);
        Object bean = null;
        for (Object obj : varRootNode.getSameNodes()) {
            if (obj instanceof BindingNode) continue;
            bean = obj;
            break;
        }
        Component comp = null;
        for (Binding binding : varRootNode.getBindings()) {
            if (!"_var".equals(binding.getAttr())) continue;
            comp = binding.getComponent();
            break;
        }
        return comp == null ? null : this.getCollectionItem(comp, bean, true);
    }

    static void postOnCreateEvents(Component item) {
        for (Component child : item.getChildren()) {
            DataBinder.postOnCreateEvents(child);
        }
        if (Events.isListened((Component)item, (String)"onCreate", (boolean)false)) {
            Events.postEvent((Event)new CreateEvent("onCreate", item, null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoadOnSaveEventListener
    implements EventListener,
    Serializable {
        private static final long serialVersionUID = 200808191508L;

        public void onEvent(Event event) {
            HashSet<BindingNode> walkedNodes = new HashSet<BindingNode>(32);
            HashSet<Dual> loadedComps = new HashSet<Dual>(64);
            Object obj = event.getData();
            if (obj instanceof List) {
                for (Object[] data : (List)obj) {
                    this.doLoad(data, walkedNodes, loadedComps);
                }
            } else {
                this.doLoad((Object[])obj, walkedNodes, loadedComps);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doLoad(Object[] data, Set<BindingNode> walkedNodes, Set<Dual> loadedComps) {
            if (!data[0].equals(DataBinder.this)) {
                return;
            }
            BindingNode node = (BindingNode)data[1];
            Binding savebinding = (Binding)data[2];
            Object bean = data[3];
            boolean refChanged = (Boolean)data[4];
            List nodes = Generics.cast((List)((List)data[5]));
            Component savecomp = (Component)data[6];
            String triggerEventName = (String)data[7];
            if (savecomp != null) {
                Execution exec = Executions.getCurrent();
                Object old = exec.getAttribute(DataBinder.LOAD_ON_SAVE_TRIGGER_COMPONENT);
                exec.setAttribute(DataBinder.LOAD_ON_SAVE_TRIGGER_COMPONENT, (Object)new Object[]{savecomp, triggerEventName});
                try {
                    this.loadAllNodes(bean, node, savecomp, savebinding, refChanged, nodes, walkedNodes, loadedComps);
                }
                finally {
                    exec.setAttribute(DataBinder.LOAD_ON_SAVE_TRIGGER_COMPONENT, old);
                }
            }
        }

        private void loadAllNodes(Object bean, BindingNode node, Component collectionComp, Binding savebinding, boolean refChanged, List<BindingNode> nodes, Set<BindingNode> walkedNodes, Set<Dual> loadedComps) {
            this.myLoadAllNodes(bean, node, new Component[]{collectionComp}, walkedNodes, savebinding, loadedComps, refChanged);
            if (!nodes.isEmpty()) {
                String path = node.getPath();
                int level = 1;
                ListIterator<BindingNode> it = nodes.listIterator(nodes.size() - 1);
                while (it.hasPrevious()) {
                    BindingNode parentNode = it.previous();
                    Set associateSameNodes = DataBinder.this.getAssociateSameNodes(parentNode, path, level);
                    for (Object obj : associateSameNodes) {
                        BindingNode samenode;
                        if (obj instanceof BindingNode) {
                            samenode = (BindingNode)obj;
                            this.myLoadAllNodes(bean, samenode, new Component[]{collectionComp}, walkedNodes, savebinding, loadedComps, refChanged);
                            continue;
                        }
                        samenode = (BindingNode)((Object[])obj)[0];
                        Component varRootComp = (Component)((Object[])obj)[1];
                        this.myLoadAllNodes(bean, samenode, new Component[]{varRootComp}, walkedNodes, savebinding, loadedComps, refChanged);
                    }
                    ++level;
                }
            }
        }

        private void myLoadAllNodes(Object bean, BindingNode node, Component[] collectionComps, Set<BindingNode> walkedNodes, Binding savebinding, Set<Dual> loadedComps, boolean refChanged) {
            if (walkedNodes.contains(node)) {
                return;
            }
            walkedNodes.add(node);
            if (collectionComps.length == 0) {
                return;
            }
            int sz = collectionComps.length;
            Component[][] kidCollectionCompsArray = new Component[sz][];
            for (int j = 0; j < sz; ++j) {
                kidCollectionCompsArray[j] = this.loadAllBindings(bean, node, collectionComps[j], savebinding, loadedComps, refChanged);
            }
            for (BindingNode kidnode : node.getKidNodes()) {
                Object kidbean = DataBinder.this.fetchValue(bean, kidnode, kidnode.getNodeId(), true);
                for (int j = 0; j < sz; ++j) {
                    this.myLoadAllNodes(kidbean, kidnode, kidCollectionCompsArray[j], walkedNodes, savebinding, loadedComps, true);
                }
            }
            for (Object obj : new ArrayList<Object>(node.getSameNodes())) {
                BindingNode samenode;
                if (!(obj instanceof BindingNode) || node == (samenode = (BindingNode)obj) || (samenode.isVar() ? !samenode.isRoot() || !this.isSameBean(samenode, bean) || samenode.isInnerCollectionNode() : node.isVar() && !this.isSameBean(samenode, bean))) continue;
                this.myLoadAllNodes(bean, samenode, collectionComps, walkedNodes, savebinding, loadedComps, refChanged);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Component[] loadAllBindings(Object bean, BindingNode node, Component collectionComp, Binding savebinding, Set<Dual> loadedComps, boolean refChanged) {
            Component[] componentArray;
            LinkedHashSet<Binding> bindings = node.getBindings();
            Component[] collectionComps = null;
            for (Binding binding : bindings) {
                if (loadedComps.contains(new Dual(collectionComp, binding))) continue;
                loadedComps.add(new Dual(collectionComp, binding));
                if (binding == savebinding) continue;
                String attr = binding.getAttr();
                boolean isCollectionItem = "_var".equals(attr);
                Component comp = binding.getComponent();
                if (DataBinder.isTemplate(comp)) {
                    Component[] clonecomps = new Component[]{};
                    if (DataBinder.isClone(collectionComp)) {
                        Component clonecomp = DataBinder.lookupClone(collectionComp, comp);
                        if (clonecomp == null) {
                            if (!isCollectionItem) throw new UiException("Cannot find associated CollectionItem=" + comp + ", binding=" + binding + ", collectionComp=" + collectionComp);
                            clonecomps = DataBinder.this.getCollectionItems(comp, bean, isCollectionItem);
                        } else {
                            clonecomps = new Component[]{clonecomp};
                        }
                    } else {
                        clonecomps = DataBinder.this.getCollectionItems(comp, bean, isCollectionItem);
                    }
                    if (refChanged) {
                        for (int j = 0; j < clonecomps.length; ++j) {
                            Component clonecomp = clonecomps[j];
                            binding.loadAttribute(clonecomp);
                        }
                    }
                    if (!isCollectionItem) continue;
                    collectionComps = clonecomps;
                    for (int j = 0; j < collectionComps.length; ++j) {
                        this.loadAllBindings(bean, node, collectionComps[j], binding, loadedComps, refChanged);
                    }
                    break;
                }
                if (!refChanged) continue;
                binding.loadAttribute(comp);
            }
            if (collectionComps == null) {
                Component[] componentArray2 = new Component[1];
                componentArray = componentArray2;
                componentArray2[0] = collectionComp;
                return componentArray;
            } else {
                componentArray = collectionComps;
            }
            return componentArray;
        }

        private boolean isSameBean(BindingNode node, Object bean) {
            LinkedHashSet<Binding> bindings = node.getBindings();
            if (bindings.isEmpty()) {
                return true;
            }
            Component comp = ((Binding)bindings.iterator().next()).getComponent();
            if (DataBinder.isTemplate(comp)) {
                return true;
            }
            Object nodebean = DataBinder.this.getBeanWithExpression(comp, node.getPath());
            return Objects.equals((Object)nodebean, (Object)bean);
        }

        private class Dual
        implements Serializable {
            private static final long serialVersionUID = 200808191743L;
            private Component _comp;
            private Binding _binding;

            public Dual(Component comp, Binding binding) {
                this._comp = comp;
                this._binding = binding;
            }

            public int hashCode() {
                return (this._comp == null ? 0 : this._comp.hashCode()) ^ (this._binding == null ? 0 : this._binding.hashCode());
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other instanceof Dual) {
                    Dual o = (Dual)other;
                    return o._comp == this._comp && o._binding == this._binding;
                }
                return false;
            }
        }
    }
}

