/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.acegi;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.ui.webapp.AuthenticationProcessingFilter;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zkplus.acegi.ShowWindowEventListener;

public class ZkAuthenticationProcessingFilter
extends AuthenticationProcessingFilter {
    private static final String ON_LOGIN_OK = "onLoginOK";
    static final String CURRENT_EVENT = "org.zkoss.zkplus.acegi.CURRENT_EVENT";
    private boolean _resendZkEvent = false;

    public void setSendZkEventAfterSuccessfulAuthentication(boolean b) {
        this._resendZkEvent = b;
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        Event evt = (Event)request.getAttribute(CURRENT_EVENT);
        return Objects.equals((Object)this.getFilterProcessesUrl(), (Object)request.getAttribute("j_loginurl")) && "onAcegiLogin".equals(evt.getName());
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        if (url == null) {
            return;
        }
        Event evt = (Event)request.getSession().getAttribute("org.zkoss.zkplus.acegi.EVENT");
        Component comp = evt.getTarget();
        String updateURI = comp.getDesktop().getUpdateURI(null);
        if (url.indexOf(updateURI) >= 0) {
            Events.postEvent((Event)new Event(ON_LOGIN_OK, comp, null));
            if (this._resendZkEvent) {
                request.getSession().removeAttribute("org.zkoss.zkplus.acegi.EVENT");
                Events.postEvent((Event)evt);
            }
            return;
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            Executions.getCurrent().sendRedirect(url);
            return;
        }
        if (!comp.isListenerAvailable("onAcegiLogin", true)) {
            ShowWindowEventListener listener = new ShowWindowEventListener();
            comp.setAttribute("onAcegiLogin", listener);
            comp.addEventListener("onAcegiLogin", listener);
        }
        Events.postEvent((Event)new Event("onAcegiLogin", comp, (Object)url));
    }

    protected String obtainPassword(HttpServletRequest request) {
        return (String)request.getAttribute("j_password");
    }

    protected String obtainUsername(HttpServletRequest request) {
        return (String)request.getAttribute("j_username");
    }
}

