/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter.sys;

import java.io.Serializable;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ext.Selectable;

public class ComboboxSelectedItemConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 201108171811L;

    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        Combobox cbx = (Combobox)comp;
        ListModel model = cbx.getModel();
        if (model != null && !(model instanceof Selectable)) {
            throw new UiException("model doesn't implement Selectable");
        }
        if (val != null) {
            if (model != null) {
                ((Selectable)model).addToSelection(val);
                return IGNORED_VALUE;
            }
            for (Comboitem ci : cbx.getItems()) {
                Object bean = ci.getValue();
                if (!val.equals(bean)) continue;
                return ci;
            }
        }
        if (model != null) {
            Set sels = ((Selectable)model).getSelection();
            if (sels != null && sels.size() > 0) {
                ((Selectable)model).clearSelection();
            }
            return IGNORED_VALUE;
        }
        return null;
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        if (val != null) {
            Combobox lbx = (Combobox)comp;
            ListModel model = lbx.getModel();
            if (model != null && !(model instanceof Selectable)) {
                throw new UiException("model doesn't implement Selectable");
            }
            if (model != null) {
                Set selection = ((Selectable)model).getSelection();
                if (selection == null || selection.size() == 0) {
                    return null;
                }
                return selection.iterator().next();
            }
            return ((Comboitem)val).getValue();
        }
        return null;
    }
}

