/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Path {
    private List<PathNode> path = new ArrayList<PathNode>();

    public void add(String origin, String evaled) {
        this.path.add(new PathNode(origin, evaled));
    }

    public int size() {
        return this.path.size();
    }

    public String getAccessFieldName() {
        StringBuilder sb = new StringBuilder();
        Iterator<PathNode> it = this.path.iterator();
        it.next();
        while (it.hasNext()) {
            sb.append('.').append(it.next().evaled);
        }
        return sb.substring(1);
    }

    public String getTrackFieldName() {
        StringBuilder sb = new StringBuilder();
        Iterator<PathNode> it = this.path.iterator();
        it.next();
        while (it.hasNext()) {
            sb.append(it.next().origin);
        }
        return sb.charAt(0) == '.' ? sb.substring(1) : sb.toString();
    }

    public List<String> getTrackFieldsList() {
        ArrayList<String> fields = new ArrayList<String>(this.path.size());
        for (PathNode node : this.path) {
            fields.add(node.origin);
        }
        return fields;
    }

    public String getTrackBasePath() {
        StringBuffer sb = new StringBuffer();
        for (PathNode prop : this.path.subList(0, this.path.size() - 1)) {
            sb.append(prop.origin);
        }
        return sb.length() > 0 && sb.charAt(0) == '.' ? sb.substring(1) : sb.toString();
    }

    public String toString() {
        return this.path.toString();
    }

    public String getTrackProperty() {
        String script = this.path.listIterator(this.path.size()).previous().origin;
        return script.charAt(0) == '.' ? script.substring(1) : script;
    }

    private static class PathNode {
        private final String origin;
        private final String evaled;

        public PathNode(String origin, String evaled) {
            this.origin = origin;
            this.evaled = evaled;
        }

        public String toString() {
            return "[" + this.origin + ", " + this.evaled + "]";
        }
    }
}

