/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.sys.Binding;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class BindContextImpl
implements BindContext,
Serializable {
    private static final long serialVersionUID = 20141230165521L;
    private final Binder _binder;
    private final Binding _binding;
    private final boolean _save;
    private final String _command;
    private final Component _component;
    private final Event _event;
    private final Map<Object, Object> _attrs;
    public static final String COMMAND_ARGS = "$BC_CMDARGS$";
    public static final String BINDING_ARGS = "$BC_BINDARGS$";
    public static final String VALIDATOR_ARGS = "$BC_VALIDARGS$";
    public static final String CONVERTER_ARGS = "$BC_CONVARGS$";

    public BindContextImpl(Binder binder, Binding binding, boolean save, String command, Component comp, Event event) {
        this._binder = binder;
        this._binding = binding;
        this._save = save;
        this._command = command;
        this._component = comp;
        this._event = event;
        this._attrs = new HashMap<Object, Object>();
    }

    @Override
    public Binder getBinder() {
        return this._binder;
    }

    @Override
    public Binding getBinding() {
        return this._binding;
    }

    @Override
    public Object getAttribute(Object key) {
        return this._attrs.get(key);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return value == null ? this._attrs.remove(key) : this._attrs.put(key, value);
    }

    @Override
    public Map<Object, Object> getAttributes() {
        return Collections.unmodifiableMap(this._attrs);
    }

    @Override
    public Object getCommandArg(String key) {
        Map m = (Map)this.getAttribute(COMMAND_ARGS);
        return m == null ? null : m.get(key);
    }

    @Override
    public Object getBindingArg(String key) {
        Map m = (Map)this.getAttribute(BINDING_ARGS);
        return m == null ? null : m.get(key);
    }

    @Override
    public Object getConverterArg(String key) {
        Map m = (Map)this.getAttribute(CONVERTER_ARGS);
        return m == null ? null : m.get(key);
    }

    @Override
    public Object getValidatorArg(String key) {
        Map m = (Map)this.getAttribute(VALIDATOR_ARGS);
        return m == null ? null : m.get(key);
    }

    public Map<String, Object> getCommandArgs() {
        return (Map)this.getAttribute(COMMAND_ARGS);
    }

    public Map<String, Object> getBindingArgs() {
        return (Map)this.getAttribute(BINDING_ARGS);
    }

    public Map<String, Object> getConverterArgs() {
        return (Map)this.getAttribute(CONVERTER_ARGS);
    }

    public Map<String, Object> getValidatorArgs() {
        return (Map)this.getAttribute(VALIDATOR_ARGS);
    }

    @Override
    public boolean isSave() {
        return this._save;
    }

    @Override
    public String getCommandName() {
        return this._command;
    }

    @Override
    public Component getComponent() {
        return this._component;
    }

    @Override
    public Event getTriggerEvent() {
        return this._event;
    }
}

