/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import java.util.List;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.bind.impl.BindChildRenderer;
import org.zkoss.bind.impl.ChildrenBindingListModelDataEvent;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;

public class ChildrenBindingListDataListener
implements ListDataListener,
Serializable {
    private static final long serialVersionUID = 20150116151900L;
    private final Component _owner;
    private final BindContext _ctx;
    private final Converter<?, ListModel<?>, Component> _conv;

    public ChildrenBindingListDataListener(Component comp, BindContext ctx, Converter<?, ListModel<?>, Component> conv) {
        this._owner = comp;
        this._ctx = ctx;
        this._conv = conv;
    }

    public void onChange(ListDataEvent event) {
        this.onListModelDataChange(new ChildrenBindingListModelDataEvent(event));
    }

    private void onListModelDataChange(ListDataEvent event) {
        ListModel model = event.getModel();
        int type = event.getType();
        int index0 = event.getIndex0();
        int index1 = event.getIndex1();
        List cbrCompsList = (List)this._owner.getAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$");
        int oldsz = cbrCompsList == null ? 0 : cbrCompsList.size();
        int newsz = model.getSize();
        boolean refreshOwnerCBAttr = false;
        if (type == 1) {
            int addedCount = index1 - index0 + 1;
            if (newsz - oldsz < 0) {
                throw new UiException("Adding causes a smaller list?");
            }
            if (oldsz + addedCount != newsz) {
                index0 = oldsz;
                index1 = newsz - 1;
            }
            this.renderModelData(model, index0, index1);
        } else if (type == 0) {
            if (index0 >= 0 && index1 >= 0) {
                this.renderModelData(model, index0, index1);
                cbrCompsList = (List)this._owner.getAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$");
                int count = index1 - index0 + 1;
                int oIndex = index1 + 1;
                for (int i = 0; i < count; ++i) {
                    Component[] oldComps;
                    for (Component oc : oldComps = (Component[])cbrCompsList.get(oIndex)) {
                        oc.detach();
                    }
                    cbrCompsList.remove(oIndex);
                }
                refreshOwnerCBAttr = true;
            } else {
                this.syncModel(model);
            }
        } else if (type == 2) {
            if (oldsz - newsz < 0) {
                throw new UiException("Removal causes a larger list?");
            }
            if (cbrCompsList != null) {
                for (int i = index0; i <= index1; ++i) {
                    Component[] oldComps = (Component[])cbrCompsList.get(index0);
                    if (oldComps != null) {
                        for (Component oc : oldComps) {
                            oc.detach();
                        }
                    }
                    cbrCompsList.remove(index0);
                }
            }
            refreshOwnerCBAttr = true;
        }
        if (refreshOwnerCBAttr) {
            this._owner.setAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$", (Object)cbrCompsList);
        }
    }

    private void syncModel(ListModel<?> model) {
        List cbrCompsList = (List)this._owner.getAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$");
        if (cbrCompsList != null) {
            this._owner.removeAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$");
            for (Component[] oldComps : cbrCompsList) {
                if (oldComps == null) continue;
                for (Component oc : oldComps) {
                    oc.detach();
                }
            }
        }
        this.renderModelData(model, 0, model.getSize() - 1);
    }

    private void renderModelData(ListModel<?> model, int from, int to) {
        BindChildRenderer renderer = new BindChildRenderer();
        if (this._conv != null) {
            List data = (List)this._conv.coerceToUi(model, this._owner, this._ctx);
            BindELContext.addModel(this._owner, data);
            if (data != null) {
                int size = data.size();
                if (to >= size) {
                    to = size - 1;
                }
                for (int i = from; i <= to; ++i) {
                    renderer.render(this._owner, data.get(i), i, size, true);
                }
            }
        }
    }
}

