/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.xel.zel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Form;
import org.zkoss.bind.impl.LoadFormBindingImpl;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.bind.sys.tracker.Tracker;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELException;
import org.zkoss.zel.impl.lang.ExpressionBuilder;
import org.zkoss.zel.impl.parser.AstIdentifier;
import org.zkoss.zel.impl.parser.AstValue;
import org.zkoss.zel.impl.parser.Node;
import org.zkoss.zk.ui.Component;

public class BindExpressionBuilder
extends ExpressionBuilder {
    private static final Logger _log = LoggerFactory.getLogger(BindExpressionBuilder.class);
    private static final String _isVisitedKey = BindExpressionBuilder.class + "_isVisted";
    protected final BindELContext _ctx;

    public BindExpressionBuilder(String expression, ELContext ctx) throws ELException {
        super(expression, ctx);
        this._ctx = (BindELContext)ctx;
    }

    public void visit(Node node) throws ELException {
        super.visit(node);
        this.visitNode(node);
    }

    private static List<String> getSrcList(BindContext ctx) {
        return (List)ctx.getAttribute("$SRCPATH$");
    }

    private static Component getDependsOnComponent(BindContext ctx) {
        return (Component)ctx.getAttribute("$DEPENDS_ON_COMP");
    }

    protected void addTracking(List<String> series) {
        boolean dotracker;
        Binding binding = this._ctx.getBinding();
        boolean bl = dotracker = !this._ctx.ignoreTracker();
        if (binding != null && series != null && !series.isEmpty()) {
            Boolean isVisted = (Boolean)this._ctx.getAttribute(_isVisitedKey);
            if (!Boolean.TRUE.equals(isVisted)) {
                this._ctx.setAttribute(_isVisitedKey, Boolean.TRUE);
            }
            Iterator<String> it = series.iterator();
            String prop = it.next();
            Binder binder = binding.getBinder();
            Tracker tracker = ((BinderCtrl)((Object)binder)).getTracker();
            BindContext bctx = (BindContext)this._ctx.getAttribute("$BINDCTX$");
            List<String> srcpath = bctx != null ? BindExpressionBuilder.getSrcList(bctx) : null;
            Component dependsOnComp = bctx != null ? BindExpressionBuilder.getDependsOnComponent(bctx) : null;
            String[] srcprops = srcpath != null ? this.properties(srcpath) : null;
            Component comp = bctx != null ? bctx.getComponent() : binding.getComponent();
            Object base = comp.getAttribute(prop, true);
            if (base instanceof Form) {
                Form formBean = (Form)base;
                String fieldName = this.fieldName(it);
                if (fieldName != null && binding instanceof SavePropertyBinding && !Boolean.TRUE.equals(isVisted)) {
                    if (_log.isDebugEnabled()) {
                        _log.debug("add save-field '{}' to form '{}'", (Object)fieldName, (Object)formBean);
                    }
                    ((BinderCtrl)((Object)binder)).addSaveFormFieldName(formBean, fieldName);
                    ((BinderCtrl)((Object)binder)).addFormAssociatedSaveBinding(comp, prop, (SavePropertyBinding)binding, fieldName);
                }
            }
            String[] props = this.properties(series);
            if (dotracker) {
                if (srcprops == null) {
                    tracker.addTracking(comp, props, binding);
                } else {
                    tracker.addDependsOn(comp, srcprops, binding, dependsOnComp, props);
                }
            }
            if (binding instanceof LoadFormBindingImpl) {
                ((LoadFormBindingImpl)binding).setSeriesLength(props.length);
            }
        }
    }

    protected void visitNode(Node node) {
        if (this._ctx.getBinding() == null) {
            return;
        }
        ArrayList<String> path = new ArrayList<String>();
        if (node instanceof AstValue) {
            int len = node.jjtGetNumChildren();
            for (int j = 0; j < len; ++j) {
                Node kid = node.jjtGetChild(j);
                path.add(BindELContext.toNodeString(kid, new StringBuffer()));
            }
            this.addTracking(path);
        } else if (node instanceof AstIdentifier && !(node.jjtGetParent() instanceof AstValue)) {
            path.add(BindELContext.toNodeString(node, new StringBuffer()));
            this.addTracking(path);
        }
    }

    private String[] properties(List<String> series) {
        String[] props = new String[series.size()];
        int j = 0;
        for (String prop : series) {
            if (prop.charAt(0) == '.') {
                prop = prop.substring(1);
            }
            props[j++] = prop;
        }
        return props;
    }

    private String fieldName(Iterator<String> it) {
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        return sb.length() == 0 ? null : (sb.charAt(0) == '.' ? sb.substring(1) : sb.toString());
    }
}

