/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter.sys;

import java.io.Serializable;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Selectbox;
import org.zkoss.zul.ext.Selectable;

public class SelectboxSelectedItemConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 201108171811L;

    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        Selectbox sbox = (Selectbox)comp;
        ListModel model = sbox.getModel();
        if (model == null) {
            throw new UiException("no model in selectbox");
        }
        if (!(model instanceof Selectable)) {
            throw new UiException("model doesn't implement Selectable");
        }
        if (val != null) {
            ((Selectable)model).addToSelection(val);
            return IGNORED_VALUE;
        }
        Set sels = ((Selectable)model).getSelection();
        if (sels != null && sels.size() > 0) {
            ((Selectable)model).clearSelection();
        }
        return IGNORED_VALUE;
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        if (val != null) {
            Selectbox sbox = (Selectbox)comp;
            ListModel model = sbox.getModel();
            if (model == null) {
                throw new UiException("no model in selectbox");
            }
            if (!(model instanceof Selectable)) {
                throw new UiException("model doesn't implement Selectable");
            }
            Set selection = ((Selectable)model).getSelection();
            if (selection == null || selection.size() == 0) {
                return null;
            }
            return selection.iterator().next();
        }
        return null;
    }
}

