/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class FormatedDateConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1463169907348730644L;

    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        String format = (String)ctx.getConverterArg("format");
        if (format == null) {
            throw new NullPointerException("format attribute not found");
        }
        Date date = (Date)val;
        return date == null ? null : FormatedDateConverter.getLocalizedSimpleDateFormat(format).format(date);
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        String format = (String)ctx.getConverterArg("format");
        if (format == null) {
            throw new NullPointerException("format attribute not found");
        }
        String date = (String)val;
        try {
            return date == null ? null : FormatedDateConverter.getLocalizedSimpleDateFormat(format).parse(date);
        }
        catch (ParseException e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
    }

    private static SimpleDateFormat getLocalizedSimpleDateFormat(String formatPtn) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatPtn, Locales.getCurrent());
        sdf.setTimeZone(TimeZones.getCurrent());
        return sdf;
    }
}

