
(function () {
	var _WidgetX = {},
		_zkMatchMediaRegexPattern = /ZKMatchMedia=[^;]*/,
		_portrait = {'0': true, '180': true}, 
		_initLandscape = jq.innerWidth() > jq.innerHeight(), 
		_initDefault = _portrait[window.orientation]; 

zk.override(zk.Widget.prototype, _WidgetX, {
	$binder: function () {
		var w = this;
		for (; w; w = w.parent) {
			if (w['$ZKBINDER$'])
				break;
		}
		if (w) {
			if (!w._$binder)
				w._$binder = new zkbind.Binder(w, this);
			return w._$binder;
		}
		return null;
	},
	$afterCommand: function (command, args) {
		var binder = this.$binder();
		if (binder)
			binder.$doAfterCommand(command, args);
	},
	unbind_: function () {
		if (this._$binder) {
			this._$binder.destroy();
			this._$binder = null;
		}
		_WidgetX.unbind_.apply(this, arguments);
	}
});

zkbind.$ = function (n, opts) {
	var widget = zk.Widget.$(n, opts);
	if (widget)
		return widget.$binder();
	zk.error('Not found ZK Binder with [' + n + ']');
};
	function _fixCommandName(prefix, opts, prop) {
		if (opts[prop]) {
			var ignores = {};
			for (var key in opts[prop]) {
				ignores[prefix + key] = opts[prop][key];
			}
			opts[prop] = ignores;
		}
	}
	
	function _matchMedia(event, binder, value) {
		var cookies = binder._cookies;
		if (event.matches) {
			var orient = '',
				dpr = 1;
			if (zk.mobile) {
				if ((_initLandscape && _initDefault) || (!_initLandscape && !_initDefault))
					_portrait = {'-90': true, '90': true};
				orient = _portrait[window.orientation] ? 'portrait' : 'landscape';
			} else {
				orient = jq.innerWidth() > jq.innerHeight() ? 'landscape' : 'portrait';
			}
			if (window.devicePixelRatio)
				dpr = window.devicePixelRatio;
			
			var ci = [new Date().getTimezoneOffset(), screen.width, screen.height, screen.colorDepth, jq.innerWidth(),
					jq.innerHeight(), jq.innerX(), jq.innerY(), dpr.toFixed(1), orient, event.matches, value.substring(16)];
			
			binder.command(value, {'$ZKCLIENTINFO$': ci});
			if (!cookies.$contains(value)) cookies.push(value);
			document.cookie = 'ZKMatchMedia=' + cookies;
			document.cookie = 'ZKClientInfo=' + JSON.stringify(ci);
		} else {
			cookies.$remove(value);
			document.cookie = 'ZKMatchMedia=' + cookies;
		}
	}

zkbind.Binder = zk.$extends(zk.Object, {
	$init: function (widget, currentTarget) {
		this.$supers('$init', arguments);
		this.$view = widget;
		this.$currentTarget = currentTarget;
		this._aftercmd = {};
		
		if (widget['$ZKMATCHMEDIA$']) {
			var cookies = [];
			matched = document.cookie.match(_zkMatchMediaRegexPattern);
			if (matched && !matched[0].trim().endsWith('='))
				cookies = matched[0].split('=')[1].split(',');
			this._cookies = cookies;
			var binder = this;
			var mqls = [];
			for (var i = 0; i < widget['$ZKMATCHMEDIA$'].length; i++) {
				var media = widget['$ZKMATCHMEDIA$'][i];
				var mql = window.matchMedia(media.substring(16));
				var handler = (function (s) {
					return function (event) {
						_matchMedia(event, binder, s);
					};
				})(media);
				mql.addListener(handler);
				handler(mql);
				mqls.push({mql: mql, handler: handler});
			}
			this._mediaQueryLists = mqls;
		}
	},
	
	after: function (cmd, fn) {
		if (!fn && jq.isFunction(cmd)) {
			fn = cmd;
			cmd = this._lastcmd;
		}
			
		var ac = this._aftercmd[cmd];
		if (!ac) this._aftercmd[cmd] = [fn];
		else
			ac.push(fn);
		return this;
	},
	
	unAfter: function (cmd, fn) {
		var ac = this._aftercmd[cmd];
		for (var j = ac ? ac.length : 0; j--;) {
			if (ac[j] == fn)
				ac.splice(j, 1);
		}
		return this;
	},
	
	destroy: function () {
		this._aftercmd = null;
		if (this._mediaQueryLists != null) {
			var mqls = this._mediaQueryLists;
			for (var i = 0; i < mqls.length; i++) {
				mqls[i].mql.removeListener(mqls[i].handler);
			}
			this._mediaQueryLists = null;
			this._cookies = null;
		}
		this.$view = null;
		this.$currentTarget = null;
	},
	
	command: function (cmd, args, opts, timeout) {
		var wgt = this.$view;
		if (opts) {
			if (opts.duplicateIgnore)
				_fixCommandName('onBindCommand$', opts, 'duplicateIgnore');
			if (opts.repeatIgnore)
				_fixCommandName('onBindCommand$', opts, 'repeatIgnore');
		}
		zAu.send(new zk.Event(wgt, 'onBindCommand$' + cmd, {cmd: cmd, args: args}, zk.copy({toServer: true}, opts)), timeout != undefined ? timeout : 38);
		this._lastcmd = cmd;
		return this;
	},
	
	globalCommand: function (cmd, args, timeout) {
		var wgt = this.$view;
		if (opts) {
			if (opts.duplicateIgnore)
				_fixCommandName('onBindGlobalCommand$', opts, 'duplicateIgnore');
			if (opts.repeatIgnore)
				_fixCommandName('onBindGlobalCommand$', opts, 'repeatIgnore');
		}
		zAu.send(new zk.Event(wgt, 'onBindGlobalCommand$' + cmd, {cmd: cmd, args: args}, zk.copy({toServer: true}, opts)), timeout != undefined ? timeout : 38);
		this._lastcmd = cmd;
		return this;
	},
	$doAfterCommand: function (cmd, args) {
		var ac = this._aftercmd[cmd];
		for (var i = 0, j = ac ? ac.length : 0; i < j; i++)
			ac[i].apply(this, [args]);
	}
}, {
	
	postCommand: function (dom, command, args, timeout) {
		var w = zk.Widget.$(dom);
		if (w) {
			var binder = w.$binder();
			if (binder) {
				binder.command(command, args, timeout);
			}
		}
	},
	
	postGlobalCommand: function (dom, command, args, timeout) {
		var w = zk.Widget.$(dom);
		if (w) {
			var binder = w.$binder();
			if (binder) {
				binder.globalCommand(command, args, timeout);
			}
		}
	}
});
})();