/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.init;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.PhaseListener;
import org.zkoss.zk.ui.util.AggregationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZKBinderPhaseListeners
implements AggregationListener {
    private static final Logger _log = LoggerFactory.getLogger(ZKBinderPhaseListeners.class);
    private static Map<String, PhaseListener> _listeners = new LinkedHashMap<String, PhaseListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHandled(Class<?> klass) {
        if (PhaseListener.class.isAssignableFrom(klass)) {
            try {
                Map<String, PhaseListener> map = _listeners;
                synchronized (map) {
                    if (!_listeners.containsKey(klass.getName())) {
                        _listeners.put(klass.getName(), (PhaseListener)klass.newInstance());
                    }
                }
            }
            catch (Exception e) {
                _log.error("Error when initial phase listener:" + klass, (Throwable)e);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PhaseListener> getSystemPhaseListeners() {
        Collection<PhaseListener> values;
        Map<String, PhaseListener> map = _listeners;
        synchronized (map) {
            values = _listeners.values();
        }
        return new LinkedList<PhaseListener>(values);
    }
}

