/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Form;
import org.zkoss.bind.FormStatus;
import org.zkoss.bind.impl.AllocUtil;
import org.zkoss.bind.impl.FormBindingImpl;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.LoadFormBinding;
import org.zkoss.bind.sys.debugger.BindingExecutionInfoCollector;
import org.zkoss.bind.sys.debugger.impl.info.LoadInfo;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.xel.ValueReference;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFormBindingImpl
extends FormBindingImpl
implements LoadFormBinding {
    private static final long serialVersionUID = 1463169907348730644L;
    private int _len;
    private Set<String> _doneDependsOn;

    public LoadFormBindingImpl(Binder binder, Component comp, String formId, String loadExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs) {
        super(binder, comp, formId, loadExpr, conditionType, command, bindingArgs);
    }

    @Override
    public void load(BindContext ctx) {
        Binder binder = this.getBinder();
        BindEvaluatorX eval = binder.getEvaluatorX();
        Component comp = this.getComponent();
        BindingExecutionInfoCollector collector = ((BinderCtrl)((Object)this.getBinder())).getBindingExecutionInfoCollector();
        Object bean = eval.getValue(ctx, comp, this._accessInfo.getProperty());
        ValueReference valref = eval.getValueReference(ctx, comp, this._accessInfo.getProperty());
        if (valref != null && valref.getBase() instanceof Form || bean instanceof Form) {
            throw new UiException(MiscUtil.formatLocationMessage("doesn't support to load a nested form , formId " + this.getFormId(), comp));
        }
        Form form = this.initFormBean(bean, bean != null ? bean.getClass() : eval.getType(ctx, comp, this._accessInfo.getProperty()), ctx);
        boolean activating = ((BinderCtrl)((Object)this.getBinder())).isActivating();
        comp.setAttribute("$LOAD_FORM_EXPR$", (Object)this.getPropertyString());
        if (activating) {
            return;
        }
        FormStatus formStatus = form.getFormStatus();
        formStatus.reset();
        binder.notifyChange(form, ".");
        binder.notifyChange(formStatus, ".");
        if (collector != null) {
            collector.addInfo(new LoadInfo("form-load", comp, this.getConditionString(ctx), this.getPropertyString(), this.getFormId(), bean, this.getArgs(), null));
        }
    }

    private String getConditionString(BindContext ctx) {
        StringBuilder condition = new StringBuilder();
        if (this.getConditionType() == ConditionType.BEFORE_COMMAND) {
            condition.append("before = '").append(this.getCommandName()).append("'");
        } else if (this.getConditionType() == ConditionType.AFTER_COMMAND) {
            condition.append("after = '").append(this.getCommandName()).append("'");
        } else {
            condition.append(ctx.getTriggerEvent() == null ? "" : "event = " + ctx.getTriggerEvent().getName());
        }
        return condition.length() == 0 ? null : condition.toString();
    }

    public void setSeriesLength(int len) {
        this._len = len;
    }

    public int getSeriesLength() {
        return this._len;
    }

    public void addDependsOnTrackings(List<String> srcpath, String basepath, String[] props) {
        if (srcpath != null) {
            String src = BindELContext.pathToString(srcpath);
            if (this._doneDependsOn != null && this._doneDependsOn.contains(src)) {
                return;
            }
            this._doneDependsOn = AllocUtil.inst.addSet(this._doneDependsOn, src);
        }
        for (String prop : props) {
            BindELContext.addDependsOnTracking(this, srcpath, basepath, prop);
        }
    }
}

